/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Date;
import java.util.Set;

public interface ValidationContext {
    public void initialize(CertificateVerifier var1);

    public void setCurrentTime(Date var1);

    public Date getCurrentTime();

    public void addSignatureForVerification(AdvancedSignature var1);

    public void addRevocationTokenForVerification(RevocationToken<?> var1);

    public void addCertificateTokenForVerification(CertificateToken var1);

    public void addTimestampTokenForVerification(TimestampToken var1);

    public void addDocumentCertificateSource(CertificateSource var1);

    public void addDocumentCertificateSource(ListCertificateSource var1);

    public void addDocumentCRLSource(OfflineRevocationSource<CRL> var1);

    public void addDocumentCRLSource(ListRevocationSource<CRL> var1);

    public void addDocumentOCSPSource(OfflineRevocationSource<OCSP> var1);

    public void addDocumentOCSPSource(ListRevocationSource<OCSP> var1);

    public void validate();

    public boolean checkAllRequiredRevocationDataPresent();

    public boolean checkAllPOECoveredByRevocationData();

    public boolean checkAllTimestampsValid();

    public boolean checkAllCertificatesValid();

    public boolean checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(AdvancedSignature var1);

    public boolean checkSignatureNotExpired(AdvancedSignature var1);

    public Set<CertificateToken> getProcessedCertificates();

    public Set<RevocationToken> getProcessedRevocations();

    public Set<TimestampToken> getProcessedTimestamps();

    public ListCertificateSource getAllCertificateSources();

    public ListCertificateSource getDocumentCertificateSource();

    public ListRevocationSource<CRL> getDocumentCRLSource();

    public ListRevocationSource<OCSP> getDocumentOCSPSource();

    public ValidationData getValidationData(AdvancedSignature var1);

    public ValidationData getValidationData(TimestampToken var1);
}

