/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.validation.RevocationDataLoadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLFirstRevocationDataLoadingStrategy
extends RevocationDataLoadingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CRLFirstRevocationDataLoadingStrategy.class);

    @Override
    public RevocationToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken) {
        RevocationToken<CRL> crlToken = this.checkCRL(certificateToken, issuerToken);
        if (crlToken != null && this.isAcceptableToken(crlToken)) {
            return crlToken;
        }
        RevocationToken<OCSP> ocspToken = this.checkOCSP(certificateToken, issuerToken);
        if (ocspToken != null && this.isAcceptableToken(ocspToken)) {
            return ocspToken;
        }
        if (crlToken == null && ocspToken == null && LOG.isDebugEnabled()) {
            LOG.debug("There is no response for {} neither from CRL nor from OCSP!", (Object)certificateToken.getDSSIdAsString());
        }
        if (this.fallbackEnabled) {
            return crlToken != null ? crlToken : ocspToken;
        }
        return null;
    }
}

