/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.ObjectFactory;
import eu.europa.esig.dss.jaxb.common.XmlDefinerUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class DiagnosticDataXmlDefiner {
    private static final String DIAGNOSTIC_DATA_SCHEMA_LOCATION = "/xsd/DiagnosticData.xsd";
    private static final String DIAGNOSTIC_DATA_XSLT_SVG_LOCATION = "/xslt/svg/diagnostic-data.xslt";
    public static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static JAXBContext jc;
    private static Schema schema;
    private static Templates svgTemplates;

    private DiagnosticDataXmlDefiner() {
    }

    public static JAXBContext getJAXBContext() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        return jc;
    }

    public static Schema getSchema() throws IOException, SAXException {
        if (schema == null) {
            try (InputStream isXSDDiagnosticData = DiagnosticDataXmlDefiner.class.getResourceAsStream(DIAGNOSTIC_DATA_SCHEMA_LOCATION);){
                SchemaFactory sf = XmlDefinerUtils.getInstance().getSecureSchemaFactory();
                schema = sf.newSchema(new Source[]{new StreamSource(isXSDDiagnosticData)});
            }
        }
        return schema;
    }

    public static Templates getSvgTemplates() throws TransformerConfigurationException, IOException {
        if (svgTemplates == null) {
            svgTemplates = DiagnosticDataXmlDefiner.loadTemplates(DIAGNOSTIC_DATA_XSLT_SVG_LOCATION);
        }
        return svgTemplates;
    }

    private static Templates loadTemplates(String path) throws TransformerConfigurationException, IOException {
        try (InputStream is = DiagnosticDataXmlDefiner.class.getResourceAsStream(path);){
            TransformerFactory transformerFactory = XmlDefinerUtils.getInstance().getSecureTransformerFactory();
            Templates templates = transformerFactory.newTemplates(new StreamSource(is));
            return templates;
        }
    }
}

