/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.alert.status;

import eu.europa.esig.dss.alert.status.MessageStatus;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ObjectStatus
extends MessageStatus {
    private Map<String, String> relatedObjectMap = new HashMap<String, String>();

    public void addRelatedObjectIdentifierAndErrorMessage(String objectId, String errorMessage) {
        this.relatedObjectMap.put(objectId, errorMessage);
    }

    public String getMessageForObjectWithId(String objectId) {
        return this.relatedObjectMap.get(objectId);
    }

    @Override
    public Collection<String> getRelatedObjectIds() {
        return this.relatedObjectMap.keySet();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && (this.relatedObjectMap == null || this.relatedObjectMap.isEmpty());
    }

    @Override
    public String getErrorString() {
        return this.getMessage() + " " + this.objectMapToString();
    }

    protected String objectMapToString() {
        StringBuilder sb = new StringBuilder();
        if (this.relatedObjectMap != null && !this.relatedObjectMap.isEmpty()) {
            sb.append("[");
            Iterator<Map.Entry<String, String>> it = this.relatedObjectMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.append(entry.getKey()).append(": ");
                sb.append(entry.getValue());
                if (!it.hasNext()) continue;
                sb.append("; ");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

