/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.xml.liquibase;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResource;
import com.suncode.upgrader.change.liquibase.LiquibaseChange;
import com.suncode.upgrader.change.liquibase.LiquibaseExecutionException;
import com.suncode.upgrader.change.liquibase.LiquibaseTaskResourceAccessor;
import com.suncode.upgrader.database.SupportedDatabase;
import com.suncode.upgrader.xml.ChangeNode;
import com.suncode.upgrader.xml.ElementParser;
import com.suncode.upgrader.xml.XmlUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class LiquibaseElementParser
implements ElementParser {
    private static final String TAG_NAME = "liquibase";
    private XMLChangeLogSAXParser changeLogParser = new XMLChangeLogSAXParser();

    @Override
    public String supportedElementTag() {
        return TAG_NAME;
    }

    @Override
    public List<Change> parse(Element element, String project, ChangeResource resource) throws Exception {
        Assert.notNull((Object)element, (String)"[Assertion failed] - this argument is required; it must not be null");
        ChangeNode changeNode = new ChangeNode(element);
        String changeLog = XmlUtils.reguiredAttribute(element, "changelog");
        DatabaseChangeLog databaseChangeLog = this.getChangeLog(changeLog, resource);
        ArrayList changes = Lists.newArrayList();
        for (ChangeSet changeSet : databaseChangeLog.getChangeSets()) {
            Set<SupportedDatabase> target = this.mergeTargetAndDbms(changeNode.getTarget(), changeSet.getDbmsSet());
            boolean failOnError = changeSet.getFailOnError() == null ? true : changeSet.getFailOnError();
            changes.add(new LiquibaseChange(changeLog, changeSet, changeNode.getVersion(), project, changeNode.isMandatory(), target, changeNode.getComment(), failOnError));
        }
        return changes;
    }

    Set<SupportedDatabase> mergeTargetAndDbms(Set<SupportedDatabase> target, Set<String> dbmsSet) {
        if (!target.isEmpty() && dbmsSet != null) {
            throw new LiquibaseExecutionException("Change " + this + " has defined 'target' on <liquibase> element and 'dbms' on <changeSet> element. You can specify only one of them.");
        }
        if (!target.isEmpty()) {
            return target;
        }
        if (dbmsSet != null) {
            return this.convertDbmsToTarget(dbmsSet);
        }
        return Sets.newHashSet();
    }

    private Set<SupportedDatabase> convertDbmsToTarget(Set<String> dbmsSet) {
        HashSet target = Sets.newHashSet();
        for (String item : dbmsSet) {
            target.add(SupportedDatabase.valueOf(item.toUpperCase()));
        }
        return target;
    }

    private DatabaseChangeLog getChangeLog(String path, ChangeResource changeResource) throws ChangeLogParseException {
        if (!path.startsWith("./")) {
            path = "./" + path;
        }
        String finalPath = path;
        ResourceLoader resourceLoader = changeResource.getResourceLoader();
        LiquibaseTaskResourceAccessor liquibaseTaskResourceAccessor = new LiquibaseTaskResourceAccessor(changeResource);
        try {
            return (DatabaseChangeLog)Scope.child((Map)ImmutableMap.of((Object)Scope.Attr.classLoader.name(), (Object)resourceLoader.getClassLoader()), () -> this.changeLogParser.parse(finalPath, null, (ResourceAccessor)liquibaseTaskResourceAccessor));
        }
        catch (ChangeLogParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ChangeLogParseException("Failed to parse change log", (Throwable)e);
        }
    }
}

