/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader;

import com.suncode.upgrader.UpgraderException;
import com.suncode.upgrader.change.liquibase.LiquibaseHelper;
import com.suncode.upgrader.database.transaction.Transaction;
import com.suncode.upgrader.database.transaction.TransactionFactory;
import com.suncode.upgrader.database.transaction.TransactionVoidCallback;
import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class UpgraderSchema {
    public static void init(DataSource dataSource) {
        Transaction transaction = TransactionFactory.getTransaction(dataSource);
        transaction.execute(new TransactionVoidCallback(){

            @Override
            protected void doInTransactionVoid(Connection connection) {
                try {
                    DefaultResourceLoader loader = new DefaultResourceLoader(this.getClass().getClassLoader());
                    LiquibaseHelper.executeChangeLog("liquibase/initUpgraderTables.xml", (ResourceLoader)loader, connection);
                }
                catch (Exception e) {
                    throw new UpgraderException("Failed to initialize database schema with upgrader specific tables", e);
                }
            }
        });
    }
}

