package com.suncode.upgrader.xml.task;

import java.util.Collections;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.google.common.collect.Lists;
import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResource;
import com.suncode.upgrader.change.task.JavaTask;
import com.suncode.upgrader.change.task.Task;
import com.suncode.upgrader.change.task.TaskChange;
import com.suncode.upgrader.xml.ChangeNode;
import com.suncode.upgrader.xml.ElementParser;
import com.suncode.upgrader.xml.XmlUtils;

public class ChangeElementParser
    implements ElementParser
{
    private static final String TAG_NAME = "change";

    @Override
    public String supportedElementTag()
    {
        return TAG_NAME;
    }

    @Override
    public List<Change> parse( Element element, String project, ChangeResource resource )
        throws Exception
    {
        String id = XmlUtils.reguiredAttribute( element, "id" );
        ChangeNode changeNode = new ChangeNode( element );

        List<Task> tasks = readTasks( element.getChildNodes() );

        Change change = new TaskChange( id, changeNode.getVersion(), project, changeNode.isMandatory(), changeNode.getTarget(), changeNode.getComment(), tasks );
        return Collections.singletonList( change );
    }

    private List<Task> readTasks( NodeList change )
    {
        List<Task> tasks = Lists.newArrayList();
        for ( int i = 0; i < change.getLength(); i++ )
        {
            Node node = change.item( i );
            if ( node.getNodeType() == Node.ELEMENT_NODE )
            {
                Task task = createTask( (Element) change.item( i ) );
                tasks.add( task );
            }
        }
        return tasks;
    }

    private Task createTask( Element item )
    {
        if ( "java".equals( item.getNodeName() ) )
        {
            String className = XmlUtils.reguiredAttribute( item, "class" );
            return new JavaTask( className );
        }
        throw new IllegalArgumentException( "Unknown task element: " + item.getNodeName() );
    }

}
