/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change.liquibase;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResult;
import com.suncode.upgrader.change.ExecutionStatus;
import com.suncode.upgrader.change.liquibase.LiquibaseExecutionException;
import com.suncode.upgrader.change.liquibase.LiquibaseHelper;
import com.suncode.upgrader.database.SupportedDatabase;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseChange
extends Change {
    private static final Logger log = LoggerFactory.getLogger(LiquibaseChange.class);
    private String changeLogPath;
    private ChangeSet changeSet;

    public LiquibaseChange(String changeLogPath, ChangeSet changeSet, String version, String project, boolean mandatory, Set<SupportedDatabase> target, String comment, boolean failOnError) {
        super(changeSet.getId(), version, project, mandatory, target, comment, failOnError);
        this.changeLogPath = changeLogPath;
        this.changeSet = changeSet;
    }

    @Override
    public ChangeResult run() {
        try {
            log.debug("Executing changeSet [{}] from file: {}", (Object)this.changeSet.getId(), (Object)this.changeLogPath);
            ExecutionStatus executionStatus = LiquibaseHelper.executeChangeSet(this.changeSet);
            return this.result(executionStatus);
        }
        catch (Exception e) {
            return this.resultFailed(new LiquibaseExecutionException("Error during changeSet execution: " + this.changeSet.getId(), e));
        }
    }

    @Override
    public void rollback() {
        try {
            log.debug("Rolling back changeSet [{}] from file: {}", (Object)this.changeSet.getId(), (Object)this.changeLogPath);
            LiquibaseHelper.rollbackChangeSet(this.changeSet);
        }
        catch (Exception e) {
            throw new LiquibaseExecutionException("Error during changeSet rollback: " + this.changeSet.getId(), e);
        }
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public String toString() {
        return "LiquibaseChange[" + this.changeLogPath + ", id: " + this.changeSet.getId() + "]";
    }
}

