/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change;

import com.suncode.upgrader.change.VersionComparator;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class DefaultVersionComparator
implements VersionComparator {
    private static final String VERSION_PATTERN = "^\\d+(\\.\\d+){2}(\\.SR\\d+)?$";
    private static final String SPLIT_PARAM = "\\.";
    private static final int MAX_NUMBER_OF_SECTION = 4;

    @Override
    public int compare(String firstVersion, String secondVersion) {
        int nonEqualSectionIndex;
        String[] splitedVersion1;
        Assert.notNull((Object)firstVersion, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)secondVersion, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (!this.checkVersionFormat(firstVersion) || !this.checkVersionFormat(secondVersion)) {
            throw new IllegalArgumentException("One of following versions has invalid format: [" + firstVersion + "] or [" + secondVersion + "]");
        }
        String[] splitedVersion0 = firstVersion.split(SPLIT_PARAM);
        if (this.isNonEqualSection(splitedVersion0, splitedVersion1 = secondVersion.split(SPLIT_PARAM), nonEqualSectionIndex = this.searchNonEqualSectionIndex(splitedVersion0, splitedVersion1))) {
            int diff = this.compareNonEqualSection(splitedVersion0, splitedVersion1, nonEqualSectionIndex);
            return Integer.signum(diff);
        }
        return Integer.signum(splitedVersion0.length - splitedVersion1.length);
    }

    private boolean isNonEqualSection(String[] splitedVersion0, String[] splitedVersion1, int nonEqualSectionIndex) {
        return nonEqualSectionIndex < splitedVersion0.length && nonEqualSectionIndex < splitedVersion1.length;
    }

    private int compareNonEqualSection(String[] splitedVersion0, String[] splitedVersion1, int nonEqualSectionIndex) {
        String version0Section = splitedVersion0[nonEqualSectionIndex];
        String version1Section = splitedVersion1[nonEqualSectionIndex];
        if (this.isLastSection(nonEqualSectionIndex)) {
            version0Section = version0Section.substring(2);
            version1Section = version1Section.substring(2);
        }
        return Integer.valueOf(version0Section).compareTo(Integer.valueOf(version1Section));
    }

    private boolean isLastSection(int nonEqualSectionIndex) {
        return nonEqualSectionIndex == 3;
    }

    private int searchNonEqualSectionIndex(String[] splitedVersion0, String[] splitedVersion1) {
        int index = 0;
        while (this.isNonEqualSection(splitedVersion0, splitedVersion1, index) && splitedVersion0[index].equals(splitedVersion1[index])) {
            ++index;
        }
        return index;
    }

    private boolean checkVersionFormat(String version) {
        Assert.notNull((Object)version, (String)"[Assertion failed] - this argument is required; it must not be null");
        return Pattern.matches(VERSION_PATTERN, version);
    }
}

