/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change;

import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class ChangeResource {
    private Resource resource;
    private ResourceLoader resourceLoader;

    public ChangeResource(String path, ResourceLoader resourceLoader) {
        this(resourceLoader.getResource(path), resourceLoader);
    }

    private ChangeResource(Resource resource, ResourceLoader resourceLoader) {
        Assert.notNull((Object)resource, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)resourceLoader, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.resource = resource;
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Resource get() {
        return this.resource;
    }

    public ChangeResource createRelative(String relativePath) throws IOException {
        Resource relative = this.get().createRelative(relativePath);
        return new ChangeResource(relative, this.resourceLoader);
    }

    public String toString() {
        return this.resource.toString();
    }
}

