/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.database.transaction;

import com.suncode.upgrader.database.transaction.DbExecutionException;
import com.suncode.upgrader.database.transaction.TransactionCallback;
import com.suncode.upgrader.database.transaction.TransactionManager;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    protected static final Logger log = LoggerFactory.getLogger(Transaction.class);
    private TransactionManager transactionManager;

    public Transaction(TransactionManager tm) {
        this.transactionManager = tm;
    }

    public <T> T execute(TransactionCallback<T> action) throws RuntimeException {
        T result = null;
        try {
            this.transactionManager.setUp();
            result = action.doInTransaction(this.transactionManager.getConnection());
            this.transactionManager.commit();
        }
        catch (RuntimeException re) {
            this.rollbackOnException(re);
            throw re;
        }
        catch (Error err) {
            this.rollbackOnException(err);
            throw err;
        }
        catch (Exception ex) {
            this.rollbackOnException(ex);
            throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
        }
        finally {
            try {
                this.transactionManager.finalization();
            }
            catch (SQLException e) {
                throw new DbExecutionException("Error during transaction finalization");
            }
        }
        return result;
    }

    private void rollbackOnException(Throwable ex) throws RuntimeException {
        try {
            this.transactionManager.rollback();
        }
        catch (SQLException e) {
            log.error("Application exception overridden by rollback error", ex);
            throw new DbExecutionException("Error during rollback");
        }
        catch (RuntimeException re) {
            log.error("Application exception overridden by rollback error", ex);
            throw re;
        }
        catch (Error err) {
            log.error("Application exception overridden by rollback error", ex);
            throw err;
        }
    }
}

