/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.database;

import com.suncode.upgrader.change.ChangeResult;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DbChangeLogHelper {
    static final String CAUSE = "Cause: ";
    static final String LAST_CAUSE = "\n...\nLast cause: ";
    static final int MAX_MESSAGE_LENGTH = 2900;
    static final int MAX_STACK_TRACE_ROW = 5;

    public static String getMessage(ChangeResult changeResult) {
        Exception rootException = null;
        Throwable lastException = null;
        StringBuilder message = new StringBuilder();
        if (changeResult.getException() == null) {
            return "";
        }
        rootException = changeResult.getException();
        lastException = DbChangeLogHelper.getLastException(rootException);
        StringWriter sw = new StringWriter();
        lastException.printStackTrace(new PrintWriter(sw));
        if (lastException != rootException) {
            message.append(CAUSE + rootException.getMessage());
            message.append((CharSequence)DbChangeLogHelper.writeStackTraceElements(rootException.getStackTrace()));
            message.append(LAST_CAUSE + sw);
        } else {
            message.append(CAUSE + sw);
        }
        return message.length() < 2900 ? message.toString() : message.substring(0, 2900);
    }

    private static StringBuilder writeStackTraceElements(StackTraceElement[] stackTrace) {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < stackTrace.length && i < 5; ++i) {
            message.append("\n" + stackTrace[i]);
        }
        return message;
    }

    private static Throwable getLastException(Throwable exception) {
        while (exception.getCause() != null && exception.getCause() != exception) {
            exception = exception.getCause();
        }
        return exception;
    }
}

