/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.database;

import com.suncode.upgrader.change.ExecutionStatus;
import com.suncode.upgrader.database.UpgraderTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class DbChangeLog
implements UpgraderTable {
    private String id;
    private String project;
    private Long date;
    private String result;
    private String message;
    private String version;

    public DbChangeLog() {
    }

    public DbChangeLog(String id, String project, Long date, String result, String message, String version) {
        this.id = id;
        this.project = project;
        this.date = date;
        this.result = result;
        this.message = message;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean hasStatus(List<ExecutionStatus> statuses) {
        Assert.notEmpty(statuses, (String)"[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
        for (ExecutionStatus status : statuses) {
            if (!this.result.equals(status.name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> mapFieldsToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("project", this.project);
        map.put("date", this.date);
        map.put("result", this.result);
        map.put("message", this.message);
        map.put("version", this.version);
        return map;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("project", (Object)this.project).append("date", (Object)this.date).append("result", (Object)this.result).append("message", (Object)this.message).append("version", (Object)this.version).toString();
    }
}

