/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change.task;

import com.google.common.collect.ImmutableList;
import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResult;
import com.suncode.upgrader.change.ExecutionStatus;
import com.suncode.upgrader.change.task.Task;
import com.suncode.upgrader.change.task.TaskExecutionException;
import com.suncode.upgrader.database.SupportedDatabase;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskChange
extends Change {
    private static final Logger log = LoggerFactory.getLogger(TaskChange.class);
    private final List<Task> tasks;

    public TaskChange(String id, String version, String project, boolean mandatory, Set<SupportedDatabase> target, String comment, List<Task> tasks) {
        super(id, version, project, mandatory, target, comment, true);
        this.tasks = ImmutableList.copyOf(tasks);
    }

    @Override
    public ChangeResult run() {
        for (Task task : this.tasks) {
            try {
                log.debug("Executing task {}", (Object)task);
                task.run();
            }
            catch (Exception e) {
                return this.resultFailed(new TaskExecutionException("Error during task execution: " + task, e));
            }
        }
        return this.result(ExecutionStatus.EXECUTED);
    }

    @Override
    public void rollback() {
        Collections.reverse(this.tasks);
        for (Task task : this.tasks) {
            try {
                log.debug("Rolling back task {}", (Object)task);
                task.rollback();
            }
            catch (Exception e) {
                throw new TaskExecutionException("Error during task rollback: " + task, e);
            }
        }
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public String toString() {
        return "TaskChange[" + this.getId() + "]";
    }
}

