/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.VersionComparator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class Changes {
    private VersionComparator comparator;
    private final Map<String, Change> changes;

    public Changes(VersionComparator comparator, List<Change> changes) {
        Assert.notNull((Object)comparator, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull(changes, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.comparator = comparator;
        this.changes = this.setChanges(changes);
    }

    private Map<String, Change> setChanges(List<Change> changeList) {
        LinkedHashMap<String, Change> changeMap = new LinkedHashMap<String, Change>();
        for (Change change : changeList) {
            if (changeMap.put(change.getId(), change) == null) continue;
            throw new IllegalArgumentException("Change id is not unique: " + change.getId());
        }
        return changeMap;
    }

    public Change getChange(String id) {
        Assert.hasText((String)id, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        return this.changes.get(id);
    }

    public List<Change> getChanges() {
        return ImmutableList.copyOf(this.changes.values());
    }

    public List<Change> getChanges(String version) {
        ArrayList result = Lists.newArrayList();
        for (Change change : this.changes.values()) {
            if (this.comparator.compare(change.getVersion(), version) != 0) continue;
            result.add(change);
        }
        return result;
    }

    public List<Change> getChanges(String sourceVersion, String targetVersion) {
        ArrayList result = Lists.newArrayList();
        for (Change change : this.changes.values()) {
            if (this.comparator.compare(change.getVersion(), sourceVersion) < 0 || this.comparator.compare(change.getVersion(), targetVersion) >= 1) continue;
            result.add(change);
        }
        return result;
    }

    public List<Change> getChangesFromVersion(String sourceVersion, boolean includeSourceVersion) {
        ArrayList result = Lists.newArrayList();
        for (Change change : this.changes.values()) {
            int difference = this.comparator.compare(change.getVersion(), sourceVersion);
            if (includeSourceVersion && difference >= 0) {
                result.add(change);
                continue;
            }
            if (difference != 1) continue;
            result.add(change);
        }
        return result;
    }

    public List<Change> getChangesFromVersion(String sourceVersion) {
        return this.getChangesFromVersion(sourceVersion, true);
    }

    public List<Change> getChangesToVersion(String targetVersion) {
        return this.getChanges("0.0.0", targetVersion);
    }
}

