/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ExecutionStatus;
import org.springframework.util.Assert;

public class ChangeResult {
    private ExecutionStatus executionStatus;
    private Change change;
    private Exception exception;

    public ChangeResult(Change change, ExecutionStatus executionStatus) {
        this(change, executionStatus, null);
    }

    public ChangeResult(Change change, ExecutionStatus executionStatus, Exception exception) {
        Assert.notNull((Object)change, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)((Object)executionStatus), (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.isTrue((executionStatus != ExecutionStatus.FAILED || exception != null ? 1 : 0) != 0, (String)"[Assertion failed] - this expression must be true");
        this.change = change;
        this.executionStatus = executionStatus;
        this.exception = exception;
    }

    public boolean isExecuted() {
        return this.executionStatus.equals((Object)ExecutionStatus.EXECUTED);
    }

    public boolean isSuccess() {
        return !this.executionStatus.equals((Object)ExecutionStatus.FAILED);
    }

    public boolean isFailed() {
        return this.executionStatus.equals((Object)ExecutionStatus.FAILED);
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String toString() {
        return this.change.getId() + "::" + (Object)((Object)this.executionStatus);
    }
}

