/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeContext;
import com.suncode.upgrader.change.ChangeResource;
import com.suncode.upgrader.change.ChangeResult;
import com.suncode.upgrader.change.ExecutionStatus;
import com.suncode.upgrader.change.liquibase.LiquibaseHelper;
import com.suncode.upgrader.change.task.TaskExecutionException;
import com.suncode.upgrader.database.ChangeLogRepository;
import com.suncode.upgrader.database.DataAccessChangeLogException;
import com.suncode.upgrader.database.DbChangeLog;
import com.suncode.upgrader.database.SupportedDatabase;
import com.suncode.upgrader.database.transaction.Transaction;
import com.suncode.upgrader.database.transaction.TransactionCallback;
import com.suncode.upgrader.database.transaction.TransactionFactory;
import com.suncode.upgrader.database.transaction.TransactionVoidCallback;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeExecutor {
    private static final Logger log = LoggerFactory.getLogger(ChangeExecutor.class);
    private DataSource dataSource;
    private ChangeLogRepository changeLogRepository;
    private final ChangeResource changeResource;

    public ChangeExecutor(DataSource dataSource, ChangeLogRepository changeLogRepository, ChangeResource changeResource) {
        this.dataSource = dataSource;
        this.changeLogRepository = changeLogRepository;
        this.changeResource = changeResource;
    }

    public ChangeResult execute(Change change) {
        ChangeResult changeResult;
        log.info("Executing change [{}]", (Object)change);
        DbChangeLog dbChangeLog = this.changeLogRepository.getChangeByPk(change.getId(), change.getProject());
        if (this.changeLogRepository.isChangeExecuted(dbChangeLog)) {
            log.info("Change [{}] was already executed with status [{}]", (Object)change, (Object)dbChangeLog.getResult());
            return new ChangeResult(change, ExecutionStatus.ALREADY_EXECUTED);
        }
        try {
            if (this.changeLogRepository.isChangeFailed(dbChangeLog)) {
                log.info("Change [{}] was already executed with status [{}]", (Object)change, (Object)ExecutionStatus.FAILED);
            }
            changeResult = this.executeChangeInTransaction(change);
        }
        catch (Exception e) {
            changeResult = new ChangeResult(change, ExecutionStatus.FAILED, e);
        }
        try {
            log.debug("Saving change result [{}] in database", (Object)changeResult);
            this.changeLogRepository.saveChangeResult(changeResult);
        }
        catch (DataAccessChangeLogException e) {
            if (changeResult.isFailed()) {
                log.error("Original exception will be override by exception during saving change result. Original exception: ", (Throwable)changeResult.getException());
            }
            if (changeResult.isExecuted()) {
                try {
                    this.rollbackChangeInTrasaction(change);
                }
                catch (Exception e1) {
                    log.error("FATAL ERROR! Can't rollback change!", (Throwable)e1);
                }
            }
            changeResult = new ChangeResult(change, ExecutionStatus.FAILED, e);
        }
        log.info("Change [{}] executed with status [{}]", (Object)changeResult.getChange().getId(), (Object)changeResult.getExecutionStatus());
        return changeResult;
    }

    private ChangeResult executeChangeInTransaction(final Change change) throws TaskExecutionException {
        Transaction transaction = TransactionFactory.getTransaction(this.dataSource);
        ChangeResult changeResult = transaction.execute(new TransactionCallback<ChangeResult>(){

            @Override
            public ChangeResult doInTransaction(Connection connection) throws TaskExecutionException, SQLException {
                try {
                    ChangeContext.init(change, connection, ChangeExecutor.this.changeResource);
                    if (!ChangeExecutor.this.runOnThisDb(connection, change.getTarget())) {
                        log.debug("Change {} skipped, because current database wasn't definied in attribute 'target'.", (Object)change);
                        ChangeResult changeResult = new ChangeResult(change, ExecutionStatus.SKIPPED);
                        return changeResult;
                    }
                    ChangeResult changeResult = change.run();
                    return changeResult;
                }
                finally {
                    ChangeContext.clear();
                }
            }
        });
        return changeResult;
    }

    private boolean runOnThisDb(Connection connection, Set<SupportedDatabase> target) {
        try {
            if (target.isEmpty()) {
                return true;
            }
            Database database = LiquibaseHelper.initDataBase(connection);
            return target.contains((Object)SupportedDatabase.valueOf(database.getShortName().toUpperCase()));
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    private void rollbackChangeInTrasaction(final Change change) throws TaskExecutionException {
        Transaction transaction = TransactionFactory.getTransaction(this.dataSource);
        transaction.execute(new TransactionVoidCallback(){

            @Override
            protected void doInTransactionVoid(Connection connection) {
                try {
                    ChangeContext.init(change, connection, ChangeExecutor.this.changeResource);
                    change.rollback();
                }
                finally {
                    ChangeContext.clear();
                }
            }
        });
    }
}

