/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResource;
import java.sql.Connection;
import org.springframework.core.io.ResourceLoader;

public class ChangeContext {
    private static final ThreadLocal<ChangeContext> threadContext = new ThreadLocal();
    private Change change;
    private Connection connection;
    private ChangeResource changeResource;

    private ChangeContext(Change change, Connection connection, ChangeResource changeResource) {
        this.connection = connection;
        this.changeResource = changeResource;
    }

    public static ChangeContext get() {
        ChangeContext context = threadContext.get();
        if (context == null) {
            throw new IllegalStateException("No active context");
        }
        return context;
    }

    public static boolean isActive() {
        return threadContext.get() != null;
    }

    public static void init(Change change, Connection connection, ChangeResource changeResource) {
        threadContext.set(new ChangeContext(change, connection, changeResource));
    }

    public static void clear() {
        threadContext.remove();
    }

    public static Connection connection() {
        return ChangeContext.get().getConnection();
    }

    public static ChangeResource changeResource() {
        return ChangeContext.get().getChangeResource();
    }

    public static ResourceLoader resourceLoader() {
        return ChangeContext.changeResource().getResourceLoader();
    }

    public static ClassLoader classLoader() {
        return ChangeContext.resourceLoader().getClassLoader();
    }

    public Change getChange() {
        return this.change;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ChangeResource getChangeResource() {
        return this.changeResource;
    }
}

