/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader;

import com.google.common.collect.ImmutableMap;
import com.suncode.upgrader.UpgradeFailedException;
import com.suncode.upgrader.UpgradeStatus;
import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeExecutor;
import com.suncode.upgrader.change.ChangeResource;
import com.suncode.upgrader.change.ChangeResult;
import com.suncode.upgrader.change.Changes;
import com.suncode.upgrader.database.ChangeLogRepository;
import com.suncode.upgrader.database.DbVersion;
import com.suncode.upgrader.database.NoDbVersionException;
import com.suncode.upgrader.util.LiquibaseScope;
import com.suncode.upgrader.xml.ChangesParser;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Scope;
import liquibase.servicelocator.PlusworkflowServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class Upgrader {
    private static final Logger log = LoggerFactory.getLogger(Upgrader.class);
    private final String project;
    private final ChangeResource changeResource;
    private final ChangesParser changesParser;
    private final ChangeExecutor changeExecutor;
    private final ChangeLogRepository changeLogRepository;
    private boolean requiredDbVersion;

    public static Builder create() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Upgrader(Builder builder) {
        Assert.notNull((Object)builder.dataSource, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.notNull((Object)builder.project, (String)"[Assertion failed] - this argument is required; it must not be null");
        ImmutableMap liquibaseScopeValues = ImmutableMap.of((Object)Scope.Attr.serviceLocator.name(), (Object)new PlusworkflowServiceLocator());
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        try (LiquibaseScope liquibaseScope = new LiquibaseScope((Map<String, Object>)liquibaseScopeValues);){
            Thread.currentThread().setContextClassLoader(builder.resourceLoader.getClassLoader());
            this.project = builder.project;
            this.changeResource = new ChangeResource(builder.changeFile, builder.resourceLoader);
            this.changesParser = builder.changesParser == null ? new ChangesParser() : builder.changesParser;
            this.changeLogRepository = builder.changeLogRepository == null ? new ChangeLogRepository(builder.dataSource) : builder.changeLogRepository;
            this.changeExecutor = builder.changeExecutor == null ? new ChangeExecutor(builder.dataSource, this.changeLogRepository, this.changeResource) : builder.changeExecutor;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
        }
    }

    public UpgradeStatus upgrade() {
        return this.upgrade(null);
    }

    /*
     * Exception decompiling
     */
    public UpgradeStatus upgrade(String fromVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public UpgradeStatus upgradeToVersion(String toVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initDbVersionForProject(String project) {
        try {
            this.changeLogRepository.getDbVersion(project);
        }
        catch (NoDbVersionException e) {
            if (this.isRequiredDbVersion()) {
                throw e;
            }
            this.changeLogRepository.addDbVersion(new DbVersion(project, null));
        }
    }

    private UpgradeStatus executeChanges(Changes changes, String version, UpgradeStatus upgradeStatus, boolean toVersion) {
        if (toVersion) {
            log.info("Upgrading project '{}' to version {}. ", (Object)this.project, (Object)(version != null ? version : "<none> (all changes will be executed)"));
        } else {
            log.info("Upgrading project '{}' to current version starting from {}. ", (Object)this.project, (Object)(version != null ? version : "<none> (all changes will be executed)"));
        }
        List<Change> changesToExecute = toVersion ? this.getChangesToVersionToExecute(changes, version) : this.getChangesToExecute(changes, version);
        for (Change change : changesToExecute) {
            ChangeResult changeResults = this.changeExecutor.execute(change);
            upgradeStatus.addChangeResult(changeResults);
            if (changeResults.isFailed() && change.isFailOnError()) {
                if (change.isMandatory()) {
                    log.info("Execution od changes was interrupted , because execution of mandatory change {} failed. Caused: ", (Object)change, (Object)changeResults.getException());
                    throw new UpgradeFailedException(this.project, upgradeStatus);
                }
                log.info("Execution of not mandatory change {} failed. Continuing execution of rest changes. Caused: ", (Object)change, (Object)changeResults.getException());
            }
            log.info("Change {} executed with status: {}", (Object)change, (Object)changeResults.getExecutionStatus());
        }
        return upgradeStatus;
    }

    private List<Change> getChangesToExecute(Changes changes, String fromVersion) {
        if (fromVersion != null) {
            return changes.getChangesFromVersion(fromVersion);
        }
        return changes.getChanges();
    }

    private List<Change> getChangesToVersionToExecute(Changes changes, String toVersion) {
        if (toVersion != null) {
            return changes.getChangesToVersion(toVersion);
        }
        return changes.getChanges();
    }

    public boolean isRequiredDbVersion() {
        return this.requiredDbVersion;
    }

    public void setRequiredDbVersion(boolean requiredDbVersion) {
        this.requiredDbVersion = requiredDbVersion;
    }

    public static class Builder {
        private DataSource dataSource;
        private String project;
        private String changeFile;
        private ResourceLoader resourceLoader;
        private ChangesParser changesParser;
        private ChangeExecutor changeExecutor;
        private ChangeLogRepository changeLogRepository;

        public Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder changeFile(String changeFile) {
            this.changeFile = changeFile;
            return this;
        }

        public Builder resourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
            return this;
        }

        Builder changesParser(ChangesParser changesParser) {
            this.changesParser = changesParser;
            return this;
        }

        Builder changeExecutor(ChangeExecutor changeExecutor) {
            this.changeExecutor = changeExecutor;
            return this;
        }

        Builder changeLogRepository(ChangeLogRepository changeLogRepository) {
            this.changeLogRepository = changeLogRepository;
            return this;
        }

        public Upgrader build() {
            return new Upgrader(this);
        }
    }
}

