package liquibase.logger;

import liquibase.logging.core.AbstractLogService;
import liquibase.logging.core.AbstractLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.logging.Level;

public class Slf4jLoggerService
    extends AbstractLogService
{

    private static final Logger log = LoggerFactory.getLogger( "com.suncode.upgrader.liquibase"  );

    private static final Slf4jLogger SLF4J_LOGGER = new Slf4jLogger();

    @Override
    public int getPriority()
    {
        return Integer.MAX_VALUE;
    }

    @Override
    public Slf4jLogger getLog( Class clazz )
    {
        return SLF4J_LOGGER;
    }

    public static class Slf4jLogger
        extends AbstractLogger
    {

        @Override
        public void log( Level level, String message, Throwable e )
        {
            log.trace( "liquibase {}", message, e );
        }

    }

}
