package com.suncode.upgrader.xml;

import java.util.List;

import org.w3c.dom.Element;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResource;

/**
 * Komponent odpowiedzialny za wczytanie includowanych plików ze zmianami.
 * 
 * <pre>
 * {@literal <}include file="include2.xml"{@literal />}
 * </pre>
 * 
 * Atrybut 'file' jest relatywną ścieżką do pliku ze zmianami
 * 
 * @author Łukasz Mocek
 */
public class IncludeElementParser
    implements ElementParser
{
    private static final String TAG_NAME = "include";

    private ChangesParser changesParser;

    public IncludeElementParser( ChangesParser changesParser )
    {
        this.changesParser = changesParser;
    }

    @Override
    public String supportedElementTag()
    {
        return TAG_NAME;
    }

    @Override
    public List<Change> parse( Element element, String project, ChangeResource resource )
        throws Exception
    {
        String file = XmlUtils.reguiredAttribute( element, "file" );
        ChangeResource includeResource = resource.createRelative( file );
        try
        {
            return changesParser.parse( includeResource, project );
        }
        catch ( Exception e )
        {
            throw new IllegalStateException( "Included file [" + file + "] is incorrect", e );
        }
    }
}
