package com.suncode.upgrader.xml;

import java.util.List;

import org.w3c.dom.Element;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResource;

/**
 * Komponent odpowiedzialny za odczytanie zmian {@linkplain Change} z pliku XML ze zmianami.
 * <p>
 * Wykorzystywany przez {@linkplain ChangesParser}
 * 
 * @author Łukasz Mocek
 */
public interface ElementParser
{
    /**
     * Zwraca nazwę wspieranego elementu
     */
    String supportedElementTag();

    /**
     * Parsuje element zgodny z nazwą elementu zwróconego przez metodę {@linkplain ElementParser#supportedElementTag()}
     * 
     * @param element element XML
     * @param projekt nazwa projektu, którego dotyczy zmiana
     * @param resource parsowany zasób
     * @return sparsowane zmiany {@linkplain Change}
     */
    List<Change> parse( Element element, String project, ChangeResource resource ) throws Exception;
}
