package com.suncode.upgrader.database.transaction;

import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionTransactionManager
    implements TransactionManager
{
    private Connection connection;

    public ConnectionTransactionManager( Connection connection )
    {
        this.connection = connection;
    }

    @Override
    public void setUp()
        throws SQLException
    {
        connection.setAutoCommit( false );
    }

    @Override
    public void commit()
        throws SQLException
    {
        connection.commit();
    }

    @Override
    public void rollback()
        throws SQLException
    {
        connection.rollback();
    }

    @Override
    public void finalization()
        throws SQLException
    {
        connection.close();
    }

    @Override
    public Connection getConnection()
    {
        return connection;
    }
}
