package com.suncode.upgrader.database;

import java.io.PrintWriter;
import java.io.StringWriter;

import com.suncode.upgrader.change.ChangeResult;

public class DbChangeLogHelper
{
    static final String CAUSE = "Cause: ";

    static final String LAST_CAUSE = "\n...\nLast cause: ";

    static final int MAX_MESSAGE_LENGTH = 2900;

    static final int MAX_STACK_TRACE_ROW = 5;

    public static String getMessage( ChangeResult changeResult )
    {
        Throwable rootException = null;
        Throwable lastException = null;
        StringBuilder message = new StringBuilder();

        if ( changeResult.getException() == null )
        {
            return "";
        }

        rootException = changeResult.getException();
        lastException = getLastException( rootException );

        StringWriter sw = new StringWriter();
        lastException.printStackTrace( new PrintWriter( sw ) );
        if ( lastException != rootException )
        {
            message.append( CAUSE + rootException.getMessage() );
            message.append( writeStackTraceElements( rootException.getStackTrace() ) );
            message.append( LAST_CAUSE + sw );
        }
        else
        {
            message.append( CAUSE + sw );
        }
        return ( message.length() < MAX_MESSAGE_LENGTH ) ? message.toString() : message.substring( 0, MAX_MESSAGE_LENGTH );
    }

    private static StringBuilder writeStackTraceElements( StackTraceElement[] stackTrace )
    {
        StringBuilder message = new StringBuilder();
        for ( int i = 0; i < stackTrace.length && i < MAX_STACK_TRACE_ROW; i++ )
        {
            message.append( "\n" + stackTrace[i] );
        }
        return message;
    }

    private static Throwable getLastException( Throwable exception )
    {
        while ( exception.getCause() != null && exception.getCause() != exception )
        {
            exception = exception.getCause();
        }
        return exception;
    }
}
