package com.suncode.upgrader.database;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

import com.suncode.upgrader.change.ExecutionStatus;

public class DbChangeLog
    implements UpgraderTable
{

    private String id;

    private String project;

    private Long date;

    private String result;

    private String message;

    private String version;

    public DbChangeLog()
    {
    }

    public DbChangeLog( String id, String project, Long date, String result, String message, String version )
    {
        this.id = id;
        this.project = project;
        this.date = date;
        this.result = result;
        this.message = message;
        this.version = version;
    }

    public String getId()
    {
        return id;
    }

    public void setId( String id )
    {
        this.id = id;
    }

    public String getProject()
    {
        return project;
    }

    public void setProject( String project )
    {
        this.project = project;
    }

    public Long getDate()
    {
        return date;
    }

    public void setDate( Long date )
    {
        this.date = date;
    }

    public String getResult()
    {
        return result;
    }

    public void setResult( String result )
    {
        this.result = result;
    }

    public String getMessage()
    {
        return message;
    }

    public void setMessage( String message )
    {
        this.message = message;
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion( String version )
    {
        this.version = version;
    }
    
    public boolean hasStatus( List<ExecutionStatus> statuses )
    {
        Assert.notEmpty( statuses, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element" );
        for( ExecutionStatus status : statuses )
        {
            if( result.equals( status.name() ) )
            {
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> mapFieldsToMap()
    {
        Map<String, Object> map = new HashMap<String, Object>();

        map.put( "id", id );
        map.put( "project", project );
        map.put( "date", date );
        map.put( "result", result );
        map.put( "message", message );
        map.put( "version", version );

        return map;
    }

    @Override
    public String toString()
    {
        return new ToStringCreator( this )
            .append( "id", id )
            .append( "project", project )
            .append( "date", date )
            .append( "result", result )
            .append( "message", message )
            .append( "version", version )
            .toString();
    }

}
