package com.suncode.upgrader.change.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

import com.suncode.upgrader.change.ChangeContext;

public class JavaTask
    implements Task
{
    private static final Logger log = LoggerFactory.getLogger( JavaTask.class );
    
    private String className;

    public JavaTask( String className )
    {
        Assert.hasText( className, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        this.className = className;
    }

    @Override
    public void run()
        throws Exception
    {
        log.debug( "Invoking method run of [{}]", className );
        createInstance().run();
    }

    @Override
    public void rollback()
        throws Exception
    {
        log.debug( "Invoking method rollback of [{}]", className );
        createInstance().rollback();
    }

    private Task createInstance()
        throws InstantiationException, IllegalAccessException, ClassNotFoundException
    {
        Class<?> taskClass = ChangeContext.classLoader().loadClass( className );
        if ( !Task.class.isAssignableFrom( taskClass ) )
        {
            throw new IllegalStateException( "Definition of this <java> task is incorrect. Check your XML file with changes. Expected class [" + Task.class
                + "], but given class [" + taskClass + "]" );
        }
        return (Task) taskClass.newInstance();
    }

    public String getClassName()
    {
        return className;
    }

    @Override
    public boolean equals( Object obj )
    {
        if ( obj == this )
        {
            return true;
        }
        if ( obj == null )
        {
            return false;
        }
        if ( obj instanceof JavaTask )
        {
            JavaTask other = (JavaTask) obj;
            return this.getClassName().equals( other.getClassName() );
        }
        return false;
    }

    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + ( ( className == null ) ? 0 : className.hashCode() );
        return result;
    }

    @Override
    public String toString()
    {
        return "JavaTask[" + className + "]";
    }
}