package com.suncode.upgrader.change;

import org.springframework.util.Assert;

/**
 * Wynik wykonania zmiany {@linkplain Change}. Zawiera zmiane oraz wynik wykonania tej zmiany - {@linkplain ExecutionStatus}. Jeżeli wykonanie zmiany
 * zakończyło sie niepowodzeniem - {@linkplain ExecutionStatus#FAILED} - to dodatkowo zawiera wyjątek, który przerwał wykonywanie zmiany.
 * 
 * @author Łukasz Mocek
 */
public class ChangeResult
{
    private ExecutionStatus executionStatus;

    private Change change;

    private Exception exception;

    public ChangeResult( Change change, ExecutionStatus executionStatus )
    {
        this( change, executionStatus, null );
    }

    public ChangeResult( Change change, ExecutionStatus executionStatus, Exception exception )
    {
        Assert.notNull( change, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( executionStatus, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.isTrue( !( executionStatus == ExecutionStatus.FAILED && exception == null ),
                       "[Assertion failed] - this expression must be true" );

        this.change = change;
        this.executionStatus = executionStatus;
        this.exception = exception;
    }

    public boolean isExecuted()
    {
        return executionStatus.equals( ExecutionStatus.EXECUTED );
    }
    
    public boolean isSuccess()
    {
        return !executionStatus.equals( ExecutionStatus.FAILED );
    }

    public boolean isFailed()
    {
        return executionStatus.equals( ExecutionStatus.FAILED );
    }

    public ExecutionStatus getExecutionStatus()
    {
        return executionStatus;
    }

    public void setExecutionStatus( ExecutionStatus executionStatus )
    {
        this.executionStatus = executionStatus;
    }

    public Change getChange()
    {
        return change;
    }

    public void setChange( Change change )
    {
        this.change = change;
    }

    public Exception getException()
    {
        return exception;
    }

    public void setException( Exception exception )
    {
        this.exception = exception;
    }
    
    @Override
    public String toString()
    {
        return change.getId() + "::" + executionStatus;
    }
}
