package com.suncode.upgrader.change;

import java.io.IOException;

import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

/**
 * Zasób wskazujący na plik xml ze zmianami, zwierający dodatkowo instancję
 * {@linkplain ResourceLoader} który powinien być używany do ładowania innych zależnych zasobów.
 * 
 * @author Cezary Kozar
 */
public class ChangeResource
{
    private Resource resource;

    private ResourceLoader resourceLoader;

    public ChangeResource( String path, ResourceLoader resourceLoader )
    {
        this( resourceLoader.getResource( path ), resourceLoader );
    }

    private ChangeResource( Resource resource, ResourceLoader resourceLoader )
    {
        Assert.notNull( resource, "[Assertion failed] - this argument is required; it must not be null" );
        Assert.notNull( resourceLoader, "[Assertion failed] - this argument is required; it must not be null" );

        this.resource = resource;
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader()
    {
        return resourceLoader;
    }

    public Resource get()
    {
        return resource;
    }

    public ChangeResource createRelative( String relativePath )
        throws IOException
    {
        Resource relative = get().createRelative( relativePath );
        return new ChangeResource( relative, resourceLoader );
    }

    @Override
    public String toString()
    {
        return resource.toString();
    }
}
