package com.suncode.upgrader;

import java.sql.Connection;

import javax.sql.DataSource;

import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

import com.suncode.upgrader.change.liquibase.LiquibaseHelper;
import com.suncode.upgrader.database.transaction.Transaction;
import com.suncode.upgrader.database.transaction.TransactionFactory;
import com.suncode.upgrader.database.transaction.TransactionVoidCallback;

public class UpgraderSchema
{
    public static void init( DataSource dataSource )
    {
        Transaction transaction = TransactionFactory.getTransaction( dataSource );
        transaction.execute( new TransactionVoidCallback()
        {
            @Override
            protected void doInTransactionVoid( Connection connection )
            {
                try
                {
                    ResourceLoader loader = new DefaultResourceLoader( getClass().getClassLoader() );
                    LiquibaseHelper.executeChangeLog( "liquibase/initUpgraderTables.xml", loader, connection );
                }
                catch ( Exception e )
                {
                    throw new UpgraderException( "Failed to initialize database schema with upgrader specific tables", e );
                }
            }
        } );
    }
}
