/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.xml;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResource;
import com.suncode.upgrader.xml.ChangesParser;
import com.suncode.upgrader.xml.ElementParser;
import com.suncode.upgrader.xml.XmlUtils;
import java.util.List;
import org.w3c.dom.Element;

public class IncludeElementParser
implements ElementParser {
    private static final String TAG_NAME = "include";
    private ChangesParser changesParser;

    public IncludeElementParser(ChangesParser changesParser) {
        this.changesParser = changesParser;
    }

    @Override
    public String supportedElementTag() {
        return TAG_NAME;
    }

    @Override
    public List<Change> parse(Element element, String project, ChangeResource resource) throws Exception {
        String file = XmlUtils.reguiredAttribute(element, "file");
        ChangeResource includeResource = resource.createRelative(file);
        try {
            return this.changesParser.parse(includeResource, project);
        }
        catch (Exception e) {
            throw new IllegalStateException("Included file [" + file + "] is incorrect", e);
        }
    }
}

