/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.xml;

import com.google.common.collect.Sets;
import com.suncode.upgrader.database.SupportedDatabase;
import com.suncode.upgrader.xml.XmlUtils;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class ChangeNode {
    private String version;
    private String comment;
    private boolean mandatory = true;
    private Set<SupportedDatabase> target;

    public ChangeNode(Element element) {
        this.version = XmlUtils.reguiredAttribute(element, "version");
        this.comment = element.getAttribute("comment");
        if (element.hasAttribute("mandatory")) {
            this.mandatory = Boolean.valueOf(element.getAttribute("mandatory"));
        }
        this.target = this.getTargetSet(element.getAttribute("target"));
    }

    private Set<SupportedDatabase> getTargetSet(String target) {
        String[] targetItems;
        HashSet targetSet = Sets.newHashSet();
        if (target.isEmpty()) {
            return targetSet;
        }
        for (String item : targetItems = target.split(",")) {
            targetSet.add(SupportedDatabase.valueOf(item.trim()));
        }
        return targetSet;
    }

    public String getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Set<SupportedDatabase> getTarget() {
        return this.target;
    }
}

