/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change.task;

import com.suncode.upgrader.change.ChangeContext;
import com.suncode.upgrader.change.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JavaTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(JavaTask.class);
    private String className;

    public JavaTask(String className) {
        Assert.hasText((String)className, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.className = className;
    }

    @Override
    public void run() throws Exception {
        log.debug("Invoking method run of [{}]", (Object)this.className);
        this.createInstance().run();
    }

    @Override
    public void rollback() throws Exception {
        log.debug("Invoking method rollback of [{}]", (Object)this.className);
        this.createInstance().rollback();
    }

    private Task createInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> taskClass = ChangeContext.classLoader().loadClass(this.className);
        if (!Task.class.isAssignableFrom(taskClass)) {
            throw new IllegalStateException("Definition of this <java> task is incorrect. Check your XML file with changes. Expected class [" + Task.class + "], but given class [" + taskClass + "]");
        }
        return (Task)taskClass.newInstance();
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JavaTask) {
            JavaTask other = (JavaTask)obj;
            return this.getClassName().equals(other.getClassName());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public String toString() {
        return "JavaTask[" + this.className + "]";
    }
}

