/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change.liquibase;

import com.google.common.collect.ImmutableMap;
import com.suncode.upgrader.change.ChangeContext;
import com.suncode.upgrader.change.ChangeResource;
import com.suncode.upgrader.change.ExecutionStatus;
import com.suncode.upgrader.change.liquibase.LiquibaseExecutionException;
import com.suncode.upgrader.change.liquibase.LiquibaseTaskResourceAccessor;
import java.sql.Connection;
import java.util.Map;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.UnsupportedDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.DatabaseException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.RollbackFailedException;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class LiquibaseHelper {
    private static final Logger log = LoggerFactory.getLogger(LiquibaseHelper.class);

    public static void executeChangeLog(String path, ResourceLoader resourceLoader, Connection connection) throws ChangeLogParseException, DatabaseException, MigrationFailedException {
        LiquibaseHelper.executeChangeLog(path, null, resourceLoader, connection);
    }

    public static void executeChangeLog(String path, Resource relativeTo, ResourceLoader resourceLoader, Connection connection) throws ChangeLogParseException, DatabaseException, MigrationFailedException {
        LiquibaseTaskResourceAccessor accessor = new LiquibaseTaskResourceAccessor(relativeTo, resourceLoader);
        try {
            Scope.child((Map)ImmutableMap.of((Object)Scope.Attr.resourceAccessor.name(), (Object)accessor), () -> {
                DatabaseChangeLog changeLog = LiquibaseHelper.getChangeLog(path, relativeTo, accessor);
                Database db = LiquibaseHelper.initDataBase(connection);
                LiquibaseHelper.executeChangeSets(changeLog, db);
            });
        }
        catch (ChangeLogParseException | DatabaseException | MigrationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute change sets", e);
        }
    }

    private static DatabaseChangeLog getChangeLog(String path, Resource relativeTo, ResourceAccessor accessor) throws ChangeLogParseException {
        if (relativeTo == null && path.startsWith(".")) {
            throw new IllegalArgumentException("Path can not be relative");
        }
        XMLChangeLogSAXParser xmlChangeLogSAXParser = new XMLChangeLogSAXParser();
        return xmlChangeLogSAXParser.parse(path, null, accessor);
    }

    public static Database initDataBase(Connection connection) throws DatabaseException {
        JdbcConnection dBConection = new JdbcConnection(connection);
        Database db = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)dBConection);
        if (db instanceof UnsupportedDatabase) {
            throw new DatabaseException("Unsupported database.");
        }
        return db;
    }

    private static void executeChangeSets(DatabaseChangeLog changeLog, Database db) throws MigrationFailedException {
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            changeSet.setFailOnError(Boolean.valueOf(true));
            ChangeSet.ExecType execType = changeSet.execute(changeLog, db);
            LiquibaseHelper.assertExecutionResult(LiquibaseHelper.executionStatusOf(execType));
        }
    }

    public static ExecutionStatus executeChangeSet(ChangeSet changeSet) throws DatabaseException, MigrationFailedException {
        try {
            ChangeResource changeResource = ChangeContext.changeResource();
            LiquibaseTaskResourceAccessor accessor = new LiquibaseTaskResourceAccessor(changeResource.get(), changeResource.getResourceLoader());
            return (ExecutionStatus)((Object)Scope.child((Map)ImmutableMap.of((Object)Scope.Attr.resourceAccessor.name(), (Object)accessor), () -> {
                ChangeSet.ExecType execType = changeSet.execute(changeSet.getChangeLog(), LiquibaseHelper.getDatabase());
                ExecutionStatus executionStatus = LiquibaseHelper.executionStatusOf(execType);
                log.debug("Changed ExecType [{}] to ExecutionStatus [{}]", (Object)execType, (Object)executionStatus);
                LiquibaseHelper.assertExecutionResult(executionStatus);
                return executionStatus;
            }));
        }
        catch (DatabaseException | MigrationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MigrationFailedException(changeSet, "Failed to execute change set", (Throwable)e);
        }
    }

    public static void rollbackChangeSet(ChangeSet changeSet) throws RollbackFailedException, DatabaseException {
        changeSet.rollback(LiquibaseHelper.getDatabase());
    }

    private static Database getDatabase() throws DatabaseException {
        Connection connection = ChangeContext.get().getConnection();
        return LiquibaseHelper.initDataBase(connection);
    }

    private static void assertExecutionResult(ExecutionStatus executionStatus) throws LiquibaseExecutionException {
        if (executionStatus == ExecutionStatus.FAILED) {
            throw new LiquibaseExecutionException("Execution of change didn't throw exception though return FAILED status. Check logs.");
        }
    }

    private static ExecutionStatus executionStatusOf(ChangeSet.ExecType result) {
        switch (result) {
            case EXECUTED: {
                return ExecutionStatus.EXECUTED;
            }
            case FAILED: {
                return ExecutionStatus.FAILED;
            }
            case SKIPPED: {
                return ExecutionStatus.SKIPPED;
            }
        }
        return ExecutionStatus.FAILED;
    }
}

