/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader.change;

import com.suncode.upgrader.change.ChangeResult;
import com.suncode.upgrader.change.ExecutionStatus;
import com.suncode.upgrader.database.SupportedDatabase;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class Change {
    private String id;
    private String version;
    private String project;
    private boolean mandatory = true;
    private Set<SupportedDatabase> target;
    private String comment;
    private boolean failOnError;

    public Change(String id, String version, String project, boolean mandatory, Set<SupportedDatabase> target, String comment, boolean failOnError) {
        Assert.hasText((String)id, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)version, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        Assert.hasText((String)project, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        this.id = id;
        this.version = version;
        this.project = project;
        this.mandatory = mandatory;
        this.target = target;
        this.comment = comment;
        this.failOnError = failOnError;
    }

    protected ChangeResult result(ExecutionStatus executionStatus) {
        return new ChangeResult(this, executionStatus);
    }

    protected ChangeResult resultFailed(Exception exception) {
        return new ChangeResult(this, ExecutionStatus.FAILED, exception);
    }

    public abstract ChangeResult run();

    public abstract void rollback();

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public String getProject() {
        return this.project;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public Set<SupportedDatabase> getTarget() {
        return this.target;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

