package liquibase.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;

/**
 * Implementacja dla bazy MSSQL importowanej z PostgreSQL. Taka baza danych ma sharkową kolumnę
 * objectid zamiast oid.
 * 
 * @author Rafał Nowacki 2017-10-11
 */
public class MssqlImportedDatabase
    extends MSSQLDatabase
{
    public MssqlImportedDatabase()
    {
        super();
    }

    @Override
    public String getShortName()
    {
        return "mssql_imported";
    }

    @Override
    public int getPriority()
    {
        return 2;
    }

    @Override
    public boolean isCorrectDatabaseImplementation( DatabaseConnection conn )
        throws DatabaseException
    {

        return super.isCorrectDatabaseImplementation( conn ) && hasObjectIdColumnName( conn );
    }

    private boolean hasObjectIdColumnName( DatabaseConnection conn )
    {
        try
        {
            DatabaseMetaData metaData = ( (JdbcConnection) conn ).getMetaData();
            ResultSet resultSet = metaData.getColumns( null, null, "usertable", null );
            while ( resultSet.next() )
            {
                String name = resultSet.getString( "COLUMN_NAME" );
                if ( "objectid".equalsIgnoreCase( name ) )
                {
                    return true;
                }
            }
        }
        catch ( Exception e )
        {
            return false;
        }

        return false;
    }
}
