package com.suncode.upgrader.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

import com.suncode.upgrader.change.Change;
import com.suncode.upgrader.change.ChangeResult;

public class DBChangeLogMapper
    implements RowMapper<DbChangeLog>
{
    public DbChangeLog mapRow( ResultSet rs, int rowNum )
        throws SQLException
    {
        DbChangeLog changeLog = new DbChangeLog();

        changeLog.setId( rs.getString( "id" ) );
        changeLog.setProject( rs.getString( "project" ) );
        changeLog.setDate( rs.getLong( "change_date" ) );
        changeLog.setResult( rs.getString( "change_result" ) );
        changeLog.setMessage( rs.getString( "message" ) );
        changeLog.setVersion( rs.getString( "version" ) );

        return changeLog;
    }

    public DbChangeLog mapChangeResult( ChangeResult changeResult )
    {
        Assert.notNull( changeResult, "[Assertion failed] - this argument is required; it must not be null" );

        Change change = changeResult.getChange();
        DbChangeLog changeLog = new DbChangeLog();
        changeLog.setId( change.getId() );
        changeLog.setProject( change.getProject() );
        changeLog.setDate( new Date().getTime() );
        changeLog.setResult( changeResult.getExecutionStatus().name() );
        changeLog.setMessage( DbChangeLogHelper.getMessage( changeResult ) );
        changeLog.setVersion( change.getVersion() );

        return changeLog;
    }
}
