/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.upgrader;

import com.google.common.collect.Lists;
import com.suncode.upgrader.change.ChangeResult;
import com.suncode.upgrader.change.ExecutionStatus;
import java.util.ArrayList;
import java.util.List;

public class UpgradeStatus {
    private List<ChangeResult> changeResults = Lists.newArrayList();

    public UpgradeStatus(List<ChangeResult> changeResults) {
        this.changeResults = changeResults;
    }

    public UpgradeStatus() {
    }

    public boolean succeed() {
        List<ChangeResult> failedChanges = this.getChangeResults(ExecutionStatus.FAILED);
        return failedChanges.isEmpty();
    }

    public List<ChangeResult> getChangeResults(ExecutionStatus status) {
        ArrayList<ChangeResult> result = new ArrayList<ChangeResult>();
        for (ChangeResult changeResult : this.changeResults) {
            if (!changeResult.getExecutionStatus().equals((Object)status)) continue;
            result.add(changeResult);
        }
        return result;
    }

    public Exception getLastException() {
        List<ChangeResult> failedChangeResults = this.getChangeResults(ExecutionStatus.FAILED);
        if (failedChangeResults.isEmpty()) {
            return null;
        }
        return failedChangeResults.get(failedChangeResults.size() - 1).getException();
    }

    public void addChangeResult(ChangeResult changeResult) {
        this.changeResults.add(changeResult);
    }
}

