package com.suncode.upgrader.xml;

import java.util.Set;

import org.w3c.dom.Element;

import com.google.common.collect.Sets;
import com.suncode.upgrader.database.SupportedDatabase;

/**
 * Klasa zawierająca wspólne atrybuty węzła zmiany
 * 
 * @author Łukasz Mocek
 */
public class ChangeNode
{
    private String version;

    private String comment;

    private boolean mandatory = true;

    private Set<SupportedDatabase> target;

    public ChangeNode( Element element )
    {
        version = XmlUtils.reguiredAttribute( element, "version" );
        comment = element.getAttribute( "comment" );
        if ( element.hasAttribute( "mandatory" ) )
        {
            mandatory = Boolean.valueOf( element.getAttribute( "mandatory" ) );
        }
        target = getTargetSet( element.getAttribute( "target" ) );
    }

    private Set<SupportedDatabase> getTargetSet( String target )
    {
        Set<SupportedDatabase> targetSet = Sets.newHashSet();

        if ( target.isEmpty() )
        {
            return targetSet;
        }

        String[] targetItems = target.split( "," );
        for ( String item : targetItems )
        {
            targetSet.add( SupportedDatabase.valueOf( item.trim() ) );
        }
        return targetSet;
    }

    public String getVersion()
    {
        return version;
    }

    public String getComment()
    {
        return comment;
    }

    public boolean isMandatory()
    {
        return mandatory;
    }

    public Set<SupportedDatabase> getTarget()
    {
        return target;
    }
}
