package com.suncode.upgrader.change.liquibase;

import com.suncode.upgrader.change.ChangeContext;
import com.suncode.upgrader.change.ChangeResource;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.InputStreamList;
import liquibase.resource.PathResource;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.URIResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.SortedSet;

/**
 * Implementacja {@linkplain ResourceAccessor}, która wspiera ładowanie zasobów z podanego {@linkplain ResourceLoader}.
 * 
 * @author Łukasz Mocek
 */
public class LiquibaseTaskResourceAccessor
    implements ResourceAccessor
{
    private final ClassLoaderResourceAccessor accessor;

    private final Resource relativeTo;

    private final ResourceLoader resourceLoader;

    public LiquibaseTaskResourceAccessor( ChangeResource changeResource )
    {
        this( changeResource.get(), changeResource.getResourceLoader() );
    }

    public LiquibaseTaskResourceAccessor( Resource relativeTo, ResourceLoader resourceLoader )
    {
        this( new ClassLoaderResourceAccessor(), relativeTo, resourceLoader );
    }

    public LiquibaseTaskResourceAccessor( ClassLoaderResourceAccessor accessor, Resource relativeTo, ResourceLoader resourceLoader )
    {
        this.accessor = accessor;
        this.relativeTo = relativeTo;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public InputStreamList openStreams( String relativeTo, String streamPath )
        throws IOException
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<String> list( String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories )
        throws IOException
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<liquibase.resource.Resource> search( String path, SearchOptions searchOptions )
        throws IOException
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<liquibase.resource.Resource> search( String path, boolean recursive )
        throws IOException
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<liquibase.resource.Resource> getAll( String path )
        throws IOException
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public liquibase.resource.Resource get( String path )
        throws IOException
    {
        Resource resource = ( path.startsWith( "." ) ) ? relativeTo.createRelative( path ) : resourceLoader.getResource( path );
        if ( resource.exists() )
        {
            return toLiquibaseResource( path, resource );
        }

        liquibase.resource.Resource liquibaseResource = accessor.get( path );
        if ( liquibaseResource.exists() || relativeTo == null )
        {
            return liquibaseResource;
        }

        Resource relativeResource = relativeTo.createRelative( path );
        if ( relativeResource.exists() )
        {
            return toLiquibaseResource( path, relativeResource );
        }

        return liquibaseResource;
    }

    @Override
    public List<String> describeLocations()
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close()
        throws Exception
    {

    }

    private liquibase.resource.Resource toLiquibaseResource( String path, Resource resource )
        throws IOException
    {
        URI uri = resource.getURI();

        if ( uri.getScheme().equals( "file" ) )
        {
            return new PathResource( path, Paths.get( uri ) );
        }
        else
        {
            return new URIResource( path, uri );
        }
    }

}