package com.suncode.upgrader;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.Lists;
import com.suncode.upgrader.change.ChangeResult;
import com.suncode.upgrader.change.ExecutionStatus;

public class UpgradeStatus
{
    private List<ChangeResult> changeResults = Lists.newArrayList();

    public UpgradeStatus( List<ChangeResult> changeResults )
    {
        this.changeResults = changeResults;
    }

    public UpgradeStatus()
    {
    }

    public boolean succeed()
    {
        List<ChangeResult> failedChanges = getChangeResults( ExecutionStatus.FAILED );
        return failedChanges.isEmpty();
    }

    public List<ChangeResult> getChangeResults( ExecutionStatus status )
    {
        List<ChangeResult> result = new ArrayList<ChangeResult>();
        for ( ChangeResult changeResult : changeResults )
        {
            if ( changeResult.getExecutionStatus().equals( status ) )
            {
                result.add( changeResult );
            }
        }
        return result;
    }

    public Exception getLastException()
    {
        List<ChangeResult> failedChangeResults = getChangeResults( ExecutionStatus.FAILED );
        if ( failedChangeResults.isEmpty() )
        {
            return null;
        }
        return failedChangeResults.get( failedChangeResults.size() - 1 ).getException();
    }

    public void addChangeResult( ChangeResult changeResult )
    {
        changeResults.add( changeResult );
    }
}
