/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;

public class MssqlImportedDatabase
extends MSSQLDatabase {
    public String getShortName() {
        return "mssql_imported";
    }

    public int getPriority() {
        return 2;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return super.isCorrectDatabaseImplementation(conn) && this.hasObjectIdColumnName(conn);
    }

    private boolean hasObjectIdColumnName(DatabaseConnection conn) {
        try {
            DatabaseMetaData metaData = ((JdbcConnection)conn).getMetaData();
            ResultSet resultSet = metaData.getColumns(null, null, "usertable", null);
            while (resultSet.next()) {
                String name = resultSet.getString("COLUMN_NAME");
                if (!"objectid".equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

