package com.suncode.upgrader.util;

import liquibase.Scope;

import java.util.Map;

public class LiquibaseScope
    implements AutoCloseable
{

    private final String scopeId;

    public LiquibaseScope( Map<String, Object> scopeValues )
    {
        try
        {
            scopeId = Scope.enter( scopeValues );
        }
        catch ( Exception e )
        {
            throw new RuntimeException( "Failed to enter liquibase scope", e );
        }
    }

    @Override
    public void close()
    {
        try
        {
            Scope.exit( scopeId );
        }
        catch ( Exception e )
        {
            throw new RuntimeException( String.format(
                "Failed to exit liquibase scope [%s]",
                scopeId
            ), e );
        }
    }

}
