package com.suncode.upgrader.change;

import java.util.Set;

import org.springframework.util.Assert;

import com.suncode.upgrader.database.SupportedDatabase;

/**
 * Baza klasa wszystkich zmian wykonywanych przez Upgradera
 * 
 * @author Łukasz Mocek
 */
public abstract class Change
{
    private String id;

    private String version;

    private String project;

    private boolean mandatory = true;

    private Set<SupportedDatabase> target;

    private String comment;
    
    private boolean failOnError;

    public Change(String id, String version, String project, boolean mandatory, Set<SupportedDatabase> target, String comment , boolean failOnError )
    {
        Assert.hasText( id, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        Assert.hasText( version, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        Assert.hasText( project, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank" );
        this.id = id;
        this.version = version;
        this.project = project;
        this.mandatory = mandatory;
        this.target = target;
        this.comment = comment;
        this.failOnError = failOnError;
    }

    protected ChangeResult result( ExecutionStatus executionStatus )
    {
        return new ChangeResult( this, executionStatus );
    }

    protected ChangeResult resultFailed( Exception exception )
    {
        return new ChangeResult( this, ExecutionStatus.FAILED, exception );
    }

    public abstract ChangeResult run();

    public abstract void rollback();

    public String getId()
    {
        return id;
    }

    public String getVersion()
    {
        return version;
    }

    public String getComment()
    {
        return comment;
    }

    public String getProject()
    {
        return project;
    }

    public boolean isMandatory()
    {
        return mandatory;
    }

    public Set<SupportedDatabase> getTarget()
    {
        return target;
    }
    
    public boolean isFailOnError()
    {
        return failOnError;
    }

    public void setFailOnError( boolean failOnError )
    {
        this.failOnError = failOnError;
    }
}
