/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.controllers.login;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DomainTable;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.security.AuthenticationButton;
import com.suncode.pwfl.security.Authenticator;
import com.suncode.pwfl.security.AuthenticatorRegistry;
import com.suncode.pwfl.security.SSORedirectType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private static final String LOGIN_URL = "/Login.do";
    private static final String LOGIN_MANUAL_URL = "/LoginManual.do";
    private static final String LOGOUT_URL = "/Logout.do";
    private static final String DEFAULT_LOGIN_REDIRECT = "/ShowUserDefaultView.do";
    private static final String[] excludedUrls = new String[]{"/Login.do", "/LoginManual.do", "/Logout.do"};
    private final ObjectMapper mapper;
    private final AuthenticatorRegistry authenticatorRegistry;

    @RequestMapping(value={"LoginManual.do", "Login.do", "LoginAction.do"})
    public String execute(@RequestAttribute(name="redirectUrl", required=false) String originalRedirectUrl, @RequestParam(name="redirectUrl", required=false) String originalRedirectUrlParam, HttpServletRequest request) throws Exception {
        String redirectUrl = this.getValidRedirectUrl(originalRedirectUrl, originalRedirectUrlParam);
        if (this.isAuthenticated(request)) {
            log.info(String.format("U\u017cytkownik jest zalogowany. Nast\u0119puje przekierowanie do strony: %s", redirectUrl));
            request.setAttribute("auditSuccess", (Object)true);
            return "redirect:" + redirectUrl;
        }
        log.info("Ustawiony adres przekierowania po zalogowaniu: " + redirectUrl);
        request.setAttribute("redirectUrl", (Object)redirectUrl);
        boolean autoLoginSSODisabledInRequest = "false".equalsIgnoreCase(request.getParameter("autoLogin"));
        boolean autoLogin = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.AUTO_LOGIN) != false && !autoLoginSSODisabledInRequest;
        boolean isLoginManual = request.getRequestURL().toString().toUpperCase().contains(LOGIN_MANUAL_URL.toUpperCase());
        if (autoLogin && !isLoginManual) {
            log.info("U\u017cytkownk ma w\u0142\u0105czone logowanie automatyczne. Po przekierowaniu nast\u0105pi pr\u00f3ba zalogowania automatycznego.");
            UriComponents uri = UriComponentsBuilder.newInstance().path("/sso/login.do").queryParam("redirectUrl", new Object[]{redirectUrl}).build().encode();
            return "redirect:" + uri.toUriString();
        }
        log.info("U\u017cytkownk ma wy\u0142\u0105czone logowanie automatyczne lub wywo\u0142ano akcj\u0119 \"LoginManual.do\". Przeprowadzone zostanie logowanie manualne.");
        request.setAttribute("showAutoLogin", (Object)autoLogin);
        List authenticators = this.authenticatorRegistry.getAllAuthenticators();
        if (authenticators.size() > 0 && !autoLoginSSODisabledInRequest) {
            request.getSession().setAttribute("redirectUrl", (Object)redirectUrl);
            Optional<AuthenticationButton> button = this.getDefaultAuthenticationButton(authenticators, isLoginManual);
            if (button.isPresent() && button.get().getRedirectType() != SSORedirectType.POST) {
                return "redirect:" + button.get().getUrl();
            }
        }
        DBManagement dbm = new DBManagement(request);
        ArrayList alDomains = dbm.GetAllDomains();
        HashMap<String, String> hmDomain = new HashMap<String, String>();
        ArrayList<DomainTable> alNewDomain = new ArrayList<DomainTable>();
        if (alDomains == null || alDomains.size() == 0) {
            request.setAttribute("setDomain", (Object)"FALSE");
        } else {
            request.setAttribute("setDomain", (Object)"TRUE");
        }
        for (int i = 0; i < alDomains.size(); ++i) {
            DomainTable domain = (DomainTable)alDomains.get(i);
            if (hmDomain.containsKey(domain.getDomainName())) continue;
            alNewDomain.add(domain);
            hmDomain.put(domain.getDomainName(), "true");
        }
        List authenticationButtons = authenticators.stream().map(this::getAuthenticationButton).filter(Objects::nonNull).collect(Collectors.toList());
        boolean hideLoginForm = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.HIDE_LOGIN_FORM);
        request.setAttribute("alDomains", alNewDomain);
        request.setAttribute("hideLoginForm", (Object)hideLoginForm);
        request.setAttribute("authenticationButtons", (Object)this.mapper.writeValueAsString(authenticationButtons));
        request.setAttribute("message", (Object)request.getParameter("message"));
        request.setAttribute("loginManual", (Object)isLoginManual);
        request.setAttribute("autoLogin", (Object)(!autoLoginSSODisabledInRequest ? 1 : 0));
        return "/login/login.jsp";
    }

    private boolean isAuthenticated(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String username = (String)session.getAttribute("username");
        return !StringUtils.isEmpty((String)username);
    }

    private String getValidRedirectUrl(String redirectUrl, String redirectUrlParam) {
        if (StringUtils.isBlank((String)redirectUrl)) {
            if (StringUtils.isNotBlank((String)redirectUrlParam)) {
                return redirectUrlParam;
            }
            return DEFAULT_LOGIN_REDIRECT;
        }
        for (String excluded : excludedUrls) {
            if (!redirectUrl.toUpperCase().contains(excluded.toUpperCase())) continue;
            if (StringUtils.isNotBlank((String)redirectUrlParam)) {
                return redirectUrlParam;
            }
            return DEFAULT_LOGIN_REDIRECT;
        }
        return redirectUrl;
    }

    private Optional<AuthenticationButton> getDefaultAuthenticationButton(List<Authenticator> authenticators, boolean isLoginManual) {
        if (isLoginManual || authenticators.size() != 1) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(authenticators.get(0).authenticationButtonDefinition());
        }
        catch (Exception e) {
            log.error("Could not get authentication button from " + authenticators.get(0).getName());
            return Optional.empty();
        }
    }

    private AuthenticationButton getAuthenticationButton(Authenticator authenticator) {
        try {
            return authenticator.authenticationButtonDefinition();
        }
        catch (Exception e) {
            log.error("Could not get authentication button from " + authenticator.getName());
            return null;
        }
    }

    @ConstructorProperties(value={"mapper", "authenticatorRegistry"})
    public LoginController(ObjectMapper mapper, AuthenticatorRegistry authenticatorRegistry) {
        this.mapper = mapper;
        this.authenticatorRegistry = authenticatorRegistry;
    }
}

