/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.plusmpm.database.documentViews.DocumentViewDisplayLocation;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.database.documentViews.dto.AddDocumentViewsTableDto;
import com.plusmpm.database.documentViews.dto.ReadDocumentViewsTableDto;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.Process;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.web.support.DocumentClassMapper;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class DocumentViewsMapper {
    private static final Logger log = LoggerFactory.getLogger(DocumentViewsMapper.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DocumentClassMapper documentClassMapper;

    public ReadDocumentViewsTableDto toDto(DocumentViewsTable documentViewsTable) {
        I18Nxpdl xpdlTranslator = new I18Nxpdl(LocaleContextHolder.getLocale());
        XpdlPackageManager xpdlPackageManager = XpdlPackageManager.getInstance();
        ReadDocumentViewsTableDto dto = ReadDocumentViewsTableDto.builder().id(documentViewsTable.getId()).documentViewName(documentViewsTable.getDocument_view_name()).documentViewDesc(documentViewsTable.getDocument_view_desc()).procDefId(documentViewsTable.getProc_def_id()).taskDefId(documentViewsTable.getTask_def_id()).userId(documentViewsTable.getUser_id()).docClassId(documentViewsTable.getDoc_class_id()).isDescending(documentViewsTable.getIs_descending().toString()).amount(String.valueOf(documentViewsTable.getAmount())).regex(documentViewsTable.getRegex()).showOn(documentViewsTable.getShowOn().name()).displayByOffice365(documentViewsTable.getDisplayByOffice365().toString()).displayByGoogleDocs(documentViewsTable.getDisplayByGoogleDocs().toString()).build();
        dto.setDocClassName(MessageHelper.getMessage((String)"Kazda"));
        if (dto.getDocClassId() != null) {
            DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)dto.getDocClassId());
            dto.setDocClassName(documentClass != null ? this.documentClassMapper.toReadDocumentClassDto(documentClass).getTranslatedName() : String.valueOf(dto.getDocClassId()));
        }
        String userName = MessageHelper.getMessage((String)"Kazdy");
        if (!StringUtils.isBlank((String)dto.getUserId())) {
            userName = dto.getUserId();
            User user = this.userService.getUser(dto.getUserId(), new String[0]);
            if (user != null) {
                userName = StringUtils.defaultIfEmpty((String)user.getFullName(), (String)userName);
            }
        }
        dto.setUserName(userName);
        Package pack = xpdlPackageManager.getPackageByProcessDefinitionId(documentViewsTable.getProc_def_id());
        dto.setTaskName(MessageHelper.getMessage((String)"Kazde"));
        if (Objects.isNull(pack)) {
            log.error("Cannot find package for process {}", (Object)dto.getProcDefId());
            dto.setProcDefId(documentViewsTable.getProc_def_id());
            dto.setProcName(MessageHelper.getMessage((String)"Kazdy"));
            return dto;
        }
        Process processTranslation = XpdlKey.forPackage((String)pack.getId()).forProcess(documentViewsTable.getProc_def_id());
        dto.setProcName(xpdlTranslator.getString(processTranslation.getKey()));
        if (!StringUtils.isBlank((String)dto.getTaskDefId())) {
            List activityTypes = this.processService.getActivityTypes(documentViewsTable.getProc_def_id());
            boolean isActivityStillInProcess = activityTypes.stream().anyMatch(activityType -> activityType.getActivityDefId().equals(dto.getTaskDefId()));
            dto.setTaskName(isActivityStillInProcess ? xpdlTranslator.getString(processTranslation.forActivity(documentViewsTable.getTask_def_id()).getKey()) : "null");
            return dto;
        }
        return dto;
    }

    public DocumentViewsTable toEntity(AddDocumentViewsTableDto addDocumentViewsTableDto) {
        return DocumentViewsTable.builder().document_view_name(addDocumentViewsTableDto.getDocumentViewName()).document_view_desc(addDocumentViewsTableDto.getDocumentViewDesc()).proc_def_id(addDocumentViewsTableDto.getProcDefId()).task_def_id(addDocumentViewsTableDto.getTaskDefId()).user_id(addDocumentViewsTableDto.getUserId()).doc_class_id(addDocumentViewsTableDto.getDocClassId()).is_descending(addDocumentViewsTableDto.getDescending()).amount(addDocumentViewsTableDto.getAmount()).regex(addDocumentViewsTableDto.getRegex()).showOn(DocumentViewDisplayLocation.valueOf((String)addDocumentViewsTableDto.getShowOn())).displayByOffice365(addDocumentViewsTableDto.getDisplayByOffice365()).displayByGoogleDocs(addDocumentViewsTableDto.getDisplayByGoogleDocs()).build();
    }
}

