/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.suncode.pwfl.archive.ExpirationType;
import com.suncode.pwfl.i18n.MessageHelper;
import java.beans.ConstructorProperties;

public class ExpirationTypeDto {
    private String name;
    private String value;

    public static ExpirationTypeDto from(ExpirationType expirationType) {
        return ExpirationTypeDto.builder().name(MessageHelper.getMessage((String)expirationType.getTranslationKey())).value(expirationType.name()).build();
    }

    @ConstructorProperties(value={"name", "value"})
    ExpirationTypeDto(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static ExpirationTypeDtoBuilder builder() {
        return new ExpirationTypeDtoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static class ExpirationTypeDtoBuilder {
        private String name;
        private String value;

        ExpirationTypeDtoBuilder() {
        }

        public ExpirationTypeDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ExpirationTypeDtoBuilder value(String value) {
            this.value = value;
            return this;
        }

        public ExpirationTypeDto build() {
            return new ExpirationTypeDto(this.name, this.value);
        }

        public String toString() {
            return "ExpirationTypeDto.ExpirationTypeDtoBuilder(name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

