/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration;

import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.administration.configuration.ComboValue;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.TranslationSupport;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.web.dto.administration.ComboValueDto;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.Shark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemParameterDto
implements Comparable<SystemParameterDto> {
    private static final Logger log = LoggerFactory.getLogger(SystemParameterDto.class);
    private Long id;
    private String parameterKey;
    private String parameterDescription;
    private String parameterType;
    private String categoryKey;
    private List<ComboValueDto> comboValues;
    private String value;
    private boolean removable = true;
    private boolean hidden = false;
    private boolean inConfFile = false;
    private String errorMessage;
    private Boolean needsRestart;
    private Boolean isWaitingForRestart;

    public static SystemParameterDto create(SystemParameter parameter) {
        String key = parameter.getKey();
        boolean isInConfFile = Shark.getInstance().getProperties().containsKey(key);
        String stringValue = "";
        String errorMessage = "";
        try {
            stringValue = SystemParameterDto.getStringValue(parameter);
        }
        catch (DecryptingException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            errorMessage = MessageHelper.getMessage((String)"Problem_z_pobraniem_hasla", (Object[])new Object[]{key});
        }
        List translators = Translators.getAll((TranslatorScope)TranslatorScope.SERVER);
        String paramDescription = TranslationSupport.getMessage((String)key, (List)translators);
        if (paramDescription.equals(key)) {
            paramDescription = "";
        }
        List<ComboValueDto> comboValuesDto = parameter.getComboValues().stream().map(ComboValueDto::create).collect(Collectors.toList());
        SystemParameterDto parameterDto = new SystemParameterDto();
        parameterDto.setId(parameter.getId());
        parameterDto.setParameterKey(key);
        parameterDto.setParameterDescription(paramDescription);
        parameterDto.setValue(stringValue);
        parameterDto.setErrorMessage(errorMessage);
        parameterDto.setComboValues(comboValuesDto);
        parameterDto.setParameterType(parameter.getParameterType().toString());
        parameterDto.setCategoryKey(parameter.getCategory().getKey());
        parameterDto.setRemovable(parameter.isRemovable());
        parameterDto.setHidden(parameter.isHidden());
        parameterDto.setInConfFile(isInConfFile);
        parameterDto.setNeedsRestart(DefinedSystemParameter.doesNeedRestart((String)parameter.getKey()));
        parameterDto.setIsWaitingForRestart(parameter.isWaitingForRestart());
        return parameterDto;
    }

    private static String getStringValue(SystemParameter parameter) {
        Object value = parameter.getValue();
        if (value != null) {
            if (parameter.getParameterType() == ParameterType.DOUBLE) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setDecimalSeparator('.');
                DecimalFormat format = new DecimalFormat("#.#", symbols);
                format.setMaximumFractionDigits(20);
                format.setMaximumIntegerDigits(20);
                return format.format(value);
            }
            return value.toString();
        }
        return "";
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.categoryKey)) {
            throw new IllegalArgumentException("Category cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.parameterKey)) {
            throw new IllegalArgumentException("Parameter key cannot be empty");
        }
        ParameterType type = ParameterType.valueOf((String)this.parameterType);
        if (type == ParameterType.COMBOBOX && this.comboValues.isEmpty()) {
            throw new IllegalArgumentException(MessageHelper.getMessage((String)"Brak_dodanych_wartosci"));
        }
    }

    public SystemParameter convert() {
        SystemParameter parameter = new SystemParameter(new Category(this.categoryKey), ParameterType.valueOf((String)this.parameterType), this.parameterKey);
        parameter.setRemovable(this.removable);
        if (this.comboValues != null) {
            List combos = this.comboValues.stream().map(comboValue -> new ComboValue(parameter, comboValue.getValue())).collect(Collectors.toList());
            parameter.setComboValues(combos);
        }
        if (this.value != null) {
            parameter.setValue((Object)this.value);
        }
        parameter.setHidden(this.hidden);
        return parameter;
    }

    @Override
    public int compareTo(SystemParameterDto toCompare) {
        String key1 = this.getParameterKey();
        String key2 = toCompare.getParameterKey();
        return key1.compareToIgnoreCase(key2);
    }

    public Long getId() {
        return this.id;
    }

    public String getParameterKey() {
        return this.parameterKey;
    }

    public String getParameterDescription() {
        return this.parameterDescription;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public String getCategoryKey() {
        return this.categoryKey;
    }

    public List<ComboValueDto> getComboValues() {
        return this.comboValues;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isInConfFile() {
        return this.inConfFile;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Boolean getNeedsRestart() {
        return this.needsRestart;
    }

    public Boolean getIsWaitingForRestart() {
        return this.isWaitingForRestart;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setParameterKey(String parameterKey) {
        this.parameterKey = parameterKey;
    }

    public void setParameterDescription(String parameterDescription) {
        this.parameterDescription = parameterDescription;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public void setCategoryKey(String categoryKey) {
        this.categoryKey = categoryKey;
    }

    public void setComboValues(List<ComboValueDto> comboValues) {
        this.comboValues = comboValues;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setInConfFile(boolean inConfFile) {
        this.inConfFile = inConfFile;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setNeedsRestart(Boolean needsRestart) {
        this.needsRestart = needsRestart;
    }

    public void setIsWaitingForRestart(Boolean isWaitingForRestart) {
        this.isWaitingForRestart = isWaitingForRestart;
    }
}

