/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.files.DocumentSearch;
import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.servlet.ShowFileServlet;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.documents.handlers.DocumentHandlerTypes;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.ActivityDocumentCount;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileAction;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.ProcessActivity;
import com.suncode.pwfl.archive.ProcessDocumentCount;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.exception.FileSizeLimitExceededException;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.DefaultCacheConfig;
import com.suncode.pwfl.form.util.FormUtils;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.CoreServiceFactory;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.util.ThreadPoolExecutor;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.ChangeFileDto;
import com.suncode.pwfl.web.dto.archive.CheckInFileDto;
import com.suncode.pwfl.web.dto.archive.DocumentDto;
import com.suncode.pwfl.web.dto.archive.DocumentFilters;
import com.suncode.pwfl.web.dto.archive.DocumentPreviewDto;
import com.suncode.pwfl.web.dto.archive.DocumentUploadProcessingState;
import com.suncode.pwfl.web.dto.archive.DocumentUploadStatus;
import com.suncode.pwfl.web.dto.archive.FileDto;
import com.suncode.pwfl.web.dto.archive.UploadFileDto;
import com.suncode.pwfl.web.dto.archive.WfFileDto;
import com.suncode.pwfl.web.dto.workflow.summary.DocumentClassDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.io.DownloadResource;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.CheckProcessAccess;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import com.suncode.pwfl.workflow.activity.ActivityDocumentDto;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import com.suncode.pwfl.workflow.process.ProcessEntity;
import com.suncode.pwfl.workflow.process.ProcessTranslationService;
import com.suncode.pwfl.workflow.process.ProcessTranslationTable;
import com.suncode.pwfl.workflow.support.DownloadFileEventManager;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileEventManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/documents"})
@Api(tags={"documents"})
public class DocumentController {
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    private final FileService fileService;
    private final FileFinder fileFinder;
    private final DocumentFinder documentFinder;
    private final DocumentService documentService;
    private final DocumentClassActionService documentClassActionService;
    private final AuthorizationHelper authorizationHelper;
    private final ActivityDocumentService activityDocumentService;
    private final TransactionWrapper transactionWrapper;
    private final MessageHelperBean messageHelper;
    private final CheckProcessAccess checkProcessAccess;
    private final ProcessTranslationService processTranslationService;
    private final ShaKey processKey;
    private final ObjectMapper mapper = new ObjectMapper();
    private final CacheFactory cacheFactory;
    private PlusWorkflowCache<UUID, DocumentUploadStatus> documentUploadStatusCache;
    public static final String RESERVED_CHARACTERS = "[<>:\"/\\\\|?*]";

    @PostConstruct
    public void initCache() {
        DefaultCacheConfig cacheConfig = DefaultCacheConfig.builder().expireAfterWrite(Duration.ofHours(2L)).build();
        this.documentUploadStatusCache = this.cacheFactory.createCache(SystemCacheId.DOCUMENT_UPLOAD_STATUS_CACHE, cacheConfig);
    }

    @Deprecated(since="4.2", forRemoval=true)
    @GetMapping(value={"query"})
    @ResponseBody
    @ApiOperation(value="Downloading document information from the process", notes="The answer contains a list of documents")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public List<WfFileDto> getDocuments(@ApiParam(value="Id of the process for which we want to download documents", required=true) @RequestParam String processId, @ApiParam(value="Id of the task for which we want to download documents. If not specified, all documents from the process will be downloaded.", required=false) @RequestParam(required=false) String activityId) {
        List<WfFile> files = this.getWfFiles(processId, activityId);
        return files.stream().map(WfFileDto::fromEntity).collect(Collectors.toList());
    }

    @GetMapping(value={"activity"})
    @ResponseBody
    @ApiOperation(value="Download information about connected documents to an activity", notes="Information about the documents, i.e. besides the files, also additional information about the document, e.g. by whom it was connected to the archive and by whom it was connected to the process, etc")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public List<ActivityDocumentDto> getActivityDocuments(@ApiParam(value="Id of the process for which we want to download documents", required=true) @RequestParam String processId, @ApiParam(value="Id of the task for which we want to download documents") @RequestParam(required=false) String activityId) {
        this.authorizationHelper.assertProcessAccess(processId, () -> {});
        if (StringUtils.isBlank((CharSequence)processId) && StringUtils.isBlank((CharSequence)activityId)) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_podano_wymaganych_parametrow"));
        }
        List documents = this.activityDocumentService.getActivityDocuments(processId, activityId, new String[]{"file", "file.documentClass", "user"});
        ArrayList<ActivityDocumentDto> documentsDtos = new ArrayList<ActivityDocumentDto>();
        for (ActivityDocument doc : documents) {
            documentsDtos.add(this.buildDocumentDto(doc));
        }
        return documentsDtos;
    }

    private ActivityDocumentDto buildDocumentDto(ActivityDocument doc) {
        I18NCustom custom = new I18NCustom();
        return ActivityDocumentDto.builder().id(doc.getFile().getId()).fileName(doc.getFile().getFileName()).description(custom.getStringSilent(doc.getFile().getDescription())).fileDate(doc.getFile().getFileDate()).size(doc.getFile().getSize()).uploader(doc.getFile().getUploader()).documentClass(doc.getFile().getDocumentClass()).attacher(doc.getUser().getUserName()).build();
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"process/count"})
    @ResponseBody
    public Long getProcessDocumentsCount(@RequestParam String processId) {
        return this.fileFinder.getDocumentsFromProcessCount(processId);
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"process/count"})
    @ResponseBody
    public List<ProcessDocumentCount> getActivityDocumentsCountForProcesses(@RequestBody List<String> processIds) {
        return this.documentFinder.getDocumentCountForProcesses(processIds);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"activity/count"})
    @ResponseBody
    public Long getActivityDocumentsCount(@RequestParam String processId, @RequestParam String activityId) {
        this.authorizationHelper.assertProcessAccess(processId, () -> {});
        return this.fileFinder.getDocumentsFromActivityCount(processId, activityId);
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"activity/count"})
    @ResponseBody
    public List<ActivityDocumentCount> getActivityDocumentsCountForActivities(@RequestBody List<ProcessActivity> activities) {
        return this.documentFinder.getDocumentCountForActivities(activities);
    }

    @PostMapping(value={"query"})
    @ResponseBody
    @ApiOperation(value="Search for documents based on filters", notes="The method searches for documents based on the specified filters. User rights are taken into account. You can search by document class (the id of the document class must be specified in the **documentClassId** parameter) or document set (the id of the document set must be specified in the **documentSetId** parameter).<br> You cannot search by document class and document set at the same time (only one parameter can be completed). Currently, the indexes of the document class/document set are still an additional filter. <br>If you do not specify indexes, all documents from the specified document class/document set will be searched. <br> > The maximum number of documents returned in a single call is 100,000")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public List<DocumentDto> findDocuments(@RequestBody DocumentFilters filters) throws SQLException {
        return filters.resolve();
    }

    @PostMapping(value={"query/count"})
    @ResponseBody
    @ApiOperation(value="Search for documents based on filters", notes="The method searches for the number of documents based on the specified filters. User permissions are taken into account. <br>The quantity can be searched by document class (the id of the document class must be specified in the **documentClassId** parameter) or by document set (the id of the document set must be specified in the **documentSetId** parameter). <br>You cannot search by document class and document set at the same time (only one parameter can be completed). Currently, an additional filter is still document class/document set indexes. If you do not specify indexes, the number of all documents from the specified document class/document set will be searched.", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public Long countDocuments(@RequestBody DocumentFilters filters) throws SQLException {
        return filters.resolveCount();
    }

    @GetMapping(value={"/view/query"})
    @ResponseBody
    @ApiOperation(value="Downloading extended document information from the process", notes="The answer contains a list of documents")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public List<FileDto> getDocumentsDto(@ApiParam(value="Id of the process for which we want to download documents", required=true) @RequestParam String processId, @ApiParam(value="Id of the task for which we want to download documents. If not specified, all documents from the process will be downloaded.") @RequestParam(required=false) String activityId) {
        this.authorizationHelper.assertProcessAccess(processId, () -> {});
        List<WfFile> files = this.getWfFiles(processId, activityId);
        ArrayList<FileDto> list = new ArrayList<FileDto>();
        for (WfFile wfFile : files) {
            list.add(new FileDto(wfFile, this.getActions(wfFile)));
        }
        return list;
    }

    private List<FileAction> getActions(WfFile wfFile) {
        String userName = SessionUtils.getLoggedUserName();
        return this.fileService.getFileActions(userName, wfFile);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"preview"})
    @ResponseBody
    public CountedResult<DocumentPreviewDto> getDocumentsForPreview(@RequestParam String processId, @RequestParam(required=false) String activityId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="date") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        List files = StringUtils.isNotBlank((CharSequence)activityId) ? this.fileFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"}) : this.fileFinder.getDocumentsFromProcess(processId, new String[]{"documentClass"});
        List documents = files.stream().map(file -> DocumentPreviewDto.builder().id(file.getId()).name(file.getFileName()).description(file.getDescription()).date(file.getFileDate()).documentClass(DocumentClassDto.fromEntity(file.getDocumentClass())).build()).sorted((Comparator<DocumentPreviewDto>)DtoComparator.of(DocumentPreviewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true).withSupport("translatedName", documentPreviewDto -> documentPreviewDto.getDocumentClass() != null ? documentPreviewDto.getDocumentClass().getTranslatedName() : "")).collect(Collectors.toList());
        return Paginator.forAll(documents).viewPageByOffset(start, limit);
    }

    @PostMapping(value={"upload"}, params={"responseAsHtml=true"})
    @ResponseBody
    @ApiOperation(value="Add document", notes="Allows you to add a document to the system to the selected document class, to a process or to an activity.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public HttpEntity<String> uploadIE(HttpServletRequest request, @ApiParam(value="HTML form containing the definition of the document:\n- If you specify the parameters `activityid` and `processid`, the document will be added to the archive and connected to the indicated activity.\n- If you specify only `processId`, the document will be added to the archive and connected to the indicated process.\n- If you do **not specify** activityid and processid or specify only activityId, the document will be added to the archive only.") UploadFileDto file, @ApiParam(value="A flag indicating if the indexes are provided in JSON format") @RequestParam(required=false) boolean indexesAsJson) throws Exception {
        WfFile uploaded = this.upload(request, file, indexesAsJson);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)uploaded);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"text/html");
        return new HttpEntity((Object)json, (MultiValueMap)headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"upload"}, produces={"application/json"})
    @ResponseBody
    @Transactional
    @ApiOperation(value="Add document", notes="Allows you to add a document to the system to the selected document class, to a process or to an activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public WfFile upload(HttpServletRequest request, @ApiParam(value="HTML form containing the definition of the document:\n- If you specify the parameters `activityid` and `processid`, the document will be added to the archive and connected to the indicated activity.\n- If you specify only `processId`, the document will be added to the archive and connected to the indicated process.\n- If you do **not specify** activityid and processid or specify only activityId, the document will be added to the archive only.") UploadFileDto file, @ApiParam(value="A flag indicating if the indexes are provided in JSON format") @RequestParam(required=false) boolean indexesAsJson) throws Exception {
        boolean success = false;
        try {
            String userName = SessionUtils.getLoggedUserName();
            DocumentController.validateFileReleaseAccess(userName, file);
            InputStream is = file.getFile().getInputStream();
            Map indexes = indexesAsJson ? (Map)this.mapper.readValue(file.getIndexesJson(), (TypeReference)new TypeReference<Map<Long, Object>>(){}) : file.getIndexes();
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(file.getDocumentClassId());
            fd.setFileName(file.getFile().getOriginalFilename());
            fd.setDescription(file.getDescription());
            fd.setUserName(userName);
            fd.setInputStream(is);
            fd.setProcessId(file.getProcessId());
            fd.setActivityId(file.getActivityId());
            fd.setIndexes(indexes);
            fd.setSaveAsNewVersion(file.isNewVersion());
            AddDocumentResultMeta result = this.documentService.addDocumentWithMetaResult(fd);
            this.executeNewDocumentAction(result, fd.getProcessId(), fd.getActivityId());
            WfFile wfFile = result.getDocument().getFile();
            wfFile.setVersion(null);
            wfFile.setDocumentClass(null);
            success = true;
            WfFile wfFile2 = wfFile;
            return wfFile2;
        }
        finally {
            request.setAttribute("audit", (Object)DocumentController.buildAudit(success, file));
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @PostMapping(value={"uploadFile"})
    public RestResult uploadDocument(@ModelAttribute UploadFileDto uploadFileDto, @RequestParam(required=false) boolean indexesAsJson) {
        return this.uploadFile(uploadFileDto, indexesAsJson);
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @PostMapping(value={"startDocumentUpload"})
    public UUID uploadDocumentAsync(@ModelAttribute UploadFileDto uploadFileDto, @RequestParam(required=false) boolean indexesAsJson) {
        String userId = SessionUtils.getLoggedUserName();
        Locale locale = LocaleContextHolder.getLocale();
        UUID uuid = UUID.randomUUID();
        this.documentUploadStatusCache.put((Object)uuid, (Object)new DocumentUploadStatus(DocumentUploadProcessingState.PROCESSING));
        ThreadPoolExecutor.execute(() -> {
            try {
                UserContext.activate((String)userId);
                LocaleContextHolder.setLocale((Locale)locale);
                RestResult result = this.uploadFile(uploadFileDto, indexesAsJson);
                if (result.isSuccess()) {
                    this.documentUploadStatusCache.put((Object)uuid, (Object)new DocumentUploadStatus(DocumentUploadProcessingState.FINISHED));
                } else {
                    this.documentUploadStatusCache.put((Object)uuid, (Object)new DocumentUploadStatus(DocumentUploadProcessingState.ERROR, result.getMessage()));
                }
            }
            catch (Exception e) {
                this.documentUploadStatusCache.put((Object)uuid, (Object)new DocumentUploadStatus(DocumentUploadProcessingState.ERROR));
            }
        });
        return uuid;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"documentUploadStatus"})
    public ResponseEntity<DocumentUploadStatus> getFileUploadStatus(@RequestParam UUID documentUploadUUID) {
        DocumentUploadStatus documentUploadStatus = (DocumentUploadStatus)this.documentUploadStatusCache.getIfPresent((Object)documentUploadUUID);
        if (documentUploadStatus == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (documentUploadStatus.getProcessingState() != DocumentUploadProcessingState.PROCESSING) {
            this.documentUploadStatusCache.invalidate((Object)documentUploadUUID);
        }
        return new ResponseEntity((Object)documentUploadStatus, (HttpStatusCode)HttpStatus.OK);
    }

    private RestResult uploadFile(UploadFileDto uploadFileDto, boolean indexesAsJson) {
        String userId = UserContext.current().getUser().getUserName();
        boolean archiveRelease = StringUtils.isBlank((CharSequence)uploadFileDto.getProcessId());
        try {
            String rightType = archiveRelease ? "archive" : "process";
            String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)uploadFileDto.getDocumentClassId()).release().custom((Object)rightType).build();
            int right = Authorization.checkRight((String)rightLevel, (String)userId, (boolean)false, (boolean)false);
            if (right != 0 && right != 1) {
                return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_dodania_dokumentu", new Object[]{userId, this.messageHelper.getMessage(rightType)}));
            }
        }
        catch (Exception e) {
            return new RestResult(false, e.getMessage());
        }
        DocumentDefinition documentDefinition = new DocumentDefinition();
        try {
            Map indexes = indexesAsJson ? (Map)this.mapper.readValue(uploadFileDto.getIndexesJson(), (TypeReference)new TypeReference<Map<Long, Object>>(){}) : uploadFileDto.getIndexes();
            documentDefinition.setIndexes(this.fileService.convertIndexTypes(indexes, uploadFileDto.getDocumentClassId().longValue()));
        }
        catch (Exception e) {
            return new RestResult(false, e.getMessage());
        }
        documentDefinition.setSaveAsNewVersion(uploadFileDto.isNewVersion());
        documentDefinition.setUserName(userId);
        documentDefinition.setDocumentClassId(uploadFileDto.getDocumentClassId());
        documentDefinition.setFileName(uploadFileDto.getFile().getOriginalFilename());
        documentDefinition.setDescription(uploadFileDto.getDescription());
        documentDefinition.setAttachToClosedActivities(uploadFileDto.isAttachToClosedActivities());
        if (!archiveRelease) {
            documentDefinition.setActivityId(uploadFileDto.getActivityId());
            documentDefinition.setProcessId(uploadFileDto.getProcessId());
        }
        try (InputStream fileInputStream = uploadFileDto.getFile().getInputStream();){
            documentDefinition.setInputStream(fileInputStream);
            AddDocumentResultMeta addDocumentResultMeta = this.documentService.addDocumentWithMetaResult(documentDefinition);
            try {
                if (archiveRelease) {
                    this.documentClassActionService.executeArchiveActions(addDocumentResultMeta.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, addDocumentResultMeta.getSavedAsNewVersion());
                } else {
                    this.documentClassActionService.executeProcessActions(addDocumentResultMeta.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, documentDefinition.getProcessId(), documentDefinition.getActivityId(), addDocumentResultMeta.getSavedAsNewVersion());
                }
            }
            catch (ServiceException e) {
                this.documentService.deleteDocument(addDocumentResultMeta.getDocument());
                throw e;
            }
        }
        catch (Exception e) {
            return new RestResult(false, e.getMessage());
        }
        return new RestResult(true);
    }

    private static AuditWrapper buildAudit(boolean success, UploadFileDto dto) {
        AuditTypes auditType;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)dto.getProcessId())) {
            auditType = AuditTypes.AUDIT_UPLOAD_FILE_FROM_PROCESS;
            params.put("processId", dto.getProcessId());
            params.put("activityId", dto.getActivityId());
            params.put("description", dto.getDescription());
            params.put("documentClassId", dto.getDocumentClassId());
        } else {
            auditType = AuditTypes.AUDIT_UPLOAD_FILE_FROM_ARCHIVE;
            params.put("description", dto.getDescription());
            params.put("docclassId", dto.getDocumentClassId());
        }
        return AuditBuilder.getInstance().params(params).type(auditType).success(success).build();
    }

    private static void validateFileReleaseAccess(String userName, UploadFileDto file) throws SQLException {
        String rightType = StringUtils.isBlank((CharSequence)file.getProcessId()) ? RightTreeBuilder.builder().system().archive().docClasses().custom((Object)file.getDocumentClassId()).release().archive().build() : RightTreeBuilder.builder().system().archive().docClasses().custom((Object)file.getDocumentClassId()).release().process().build();
        int right = Authorization.checkRight((String)rightType, (String)userName, (boolean)false, (boolean)false);
        if (right != 0 && right != 1) {
            throw new NotFullRightsException();
        }
    }

    private void executeNewDocumentAction(AddDocumentResultMeta result, String processId, String activityId) {
        try {
            if (StringUtils.isNotBlank((CharSequence)processId)) {
                this.documentClassActionService.executeProcessActions(result.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, processId, activityId, result.getSavedAsNewVersion());
            } else {
                this.documentClassActionService.executeArchiveActions(result.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
        }
        catch (ServiceException e) {
            ServiceFactory.getDocumentService().deleteDocument(result.getDocument());
            throw e;
        }
    }

    @GetMapping(value={"download/{fileId}"})
    @ApiOperation(value="Download document", notes="Downloads the document with the specified file id")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public ResponseEntity<DownloadResource> download(@ApiParam(value="Id of the file you want to download (parameter passed in the servlet path)", required=true) @PathVariable Long fileId, HttpServletRequest request) throws Exception {
        Long newestFileId = this.fileService.getVersionForFile(fileId).getNewestFile().getId();
        return this.authorizationHelper.ensureFileAccess(newestFileId, () -> this.downloadResource(request, fileId));
    }

    @GetMapping(value={"download/guid/{guid}"})
    @ApiOperation(value="Download document", notes="Downloads the document with the specified GUID")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public ResponseEntity<DownloadResource> downloadByGuid(@ApiParam(value="GUID of the file you want to download", required=true) @PathVariable String guid, HttpServletRequest request) throws Exception {
        String userName = SessionUtils.getLoggedUserName();
        WfFile wfFile = this.fileFinder.findByGuid(UUID.fromString(guid));
        if (Authorization.hasRightsToDisplayDocumentByLink((Long)wfFile.getId(), (String)userName)) {
            return new ResponseEntity((Object)this.downloadResource(request, wfFile.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    private DownloadResource downloadResource(HttpServletRequest request, Long fileId) throws Exception {
        WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass", "version"});
        OpenedFileContext fileContext = ReadFileEventManager.execute((HttpServletRequest)request, (WfFile)file);
        fileContext = DownloadFileEventManager.execute((OpenedFileContext)fileContext);
        String filename = fileContext.getFileName().replaceAll(RESERVED_CHARACTERS, "_") + "." + fileContext.getExtension();
        return new DownloadResource(filename, (long)fileContext.getInputStream().available(), fileContext.getInputStream());
    }

    @DeleteMapping(value={"{fileId}/{processId}"})
    @ResponseBody
    @Transactional
    @ApiOperation(value="Disconnecting a document from a process", notes="Disconnects the document from the indicated process, but the document is still available in the system")
    @ApiResponses(value={@ApiResponse(code=204, message="The query was successful"), @ApiResponse(code=400, message="Bad input parameter")})
    public void detachFromProcess(@ApiParam(value="Id of the file we want to remove ( parameter passed in the servlet path)", required=true) @PathVariable Long fileId, @ApiParam(value="Id of the process from which we are removing the document", required=true) @PathVariable String processId) throws IOException {
        this.authorizationHelper.assertProcessAccess(processId, () -> {});
        this.fileService.detachFileFromProcess(fileId, processId);
        this.documentClassActionService.executeProcessActions(this.documentService.getDocument(fileId), DocumentEventTypes.DELETE_DOCUMENT_FROM_PROCESS, processId, null);
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"/detach/{processId}/{activityId}"})
    @ResponseBody
    @Transactional
    public ResponseEntity<?> detachFromActivity(@RequestParam List<Long> fileIds, @PathVariable String processId, @PathVariable String activityId) {
        for (Long fileId2 : fileIds) {
            if (this.hasRightsToDetach(fileId2, processId, activityId).booleanValue()) continue;
            log.error("User has no rights to detach file id: " + fileId2);
            return new ResponseEntity((Object)ImmutableMap.of((Object)"reload", (Object)false), (HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (CollectionUtils.isEmpty(fileIds)) {
            return new ResponseEntity((Object)ImmutableMap.of((Object)"reload", (Object)false), (HttpStatusCode)HttpStatus.OK);
        }
        Boolean shouldReload = this.shouldReload(fileIds);
        this.fileService.detachFilesFromActivity(fileIds, processId, activityId);
        fileIds.forEach(fileId -> this.documentClassActionService.executeProcessActions(this.documentService.getDocument(fileId), DocumentEventTypes.DELETE_DOCUMENT_FROM_PROCESS, processId, activityId));
        return new ResponseEntity((Object)ImmutableMap.of((Object)"reload", (Object)shouldReload), (HttpStatusCode)HttpStatus.OK);
    }

    private Boolean shouldReload(List<Long> fileIds) {
        return (Boolean)new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager()).execute(status -> fileIds.stream().anyMatch(fileId -> {
            WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass"});
            DocumentClass documentClass = file.getDocumentClass();
            return documentClass.getActions().stream().anyMatch(action -> action.getHandlerType() == DocumentHandlerTypes.REWRITE_IDX_FROM_DOC_TO_PROCESS);
        }));
    }

    @DeleteMapping(value={"{fileId}"})
    @ResponseBody
    @Transactional
    @ApiOperation(value="Delete document", notes="The method removes the file from the system. If the file to be deleted is version ex 2, and the whole document is version 5, then all versions upwards will be deleted, i.e. only version 1 file will be left, unless the parameter `deleteAllVersions=true`, then all versions will be deleted.")
    @ApiResponses(value={@ApiResponse(code=204, message="The query was successful"), @ApiResponse(code=400, message="Bad input parameter")})
    public void deleteFile(HttpServletRequest request, @ApiParam(value="Id of the file you want to delete (parameter passed in the servlet path)", required=true) @PathVariable Long fileId, @ApiParam(value="Specifies whether all previous versions of this document are also to be deleted", defaultValue="false") @RequestParam(defaultValue="false") boolean deleteAllVersions) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("fileId", (Object)fileId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_ARCHIVE).params(auditParamsBuilder.build());
        WfFile file = this.fileService.getFile(fileId, new String[0]);
        if (file != null) {
            WfDocument document = this.documentService.getDocument(fileId);
            if (!this.hasRightToDeleteFile(fileId, document.getDocumentClassId())) {
                auditBuilder.buildFailure(request);
                return;
            }
            if (deleteAllVersions) {
                this.documentService.deleteAllDocumentVersions(document);
            } else {
                this.fileService.deleteFile(fileId);
            }
            DocumentClassActionService dcActionService = CoreServiceFactory.getDocumentClassActionService();
            dcActionService.executeArchiveActions(document, DocumentEventTypes.DELETE_DOCUMENT_FROM_ARCHIVE);
            auditBuilder.buildSuccess(request);
        }
    }

    @PutMapping(value={"{fileId}/indexes"})
    @ResponseBody
    @ApiOperation(value="Change of document index values", notes="The method changes the passed index values in the specified document. The user must have permission to modify the document.")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public void changeIndexes(@ApiParam(value="Id of the file whose indexes we want to change (parameter passed in the servlet path)", required=true) @PathVariable Long fileId, @ApiParam(value="JSON object containing the indexes to be changed", required=true) @RequestBody Map<Long, Object> indexes) {
        WfFile file = this.fileService.getFile(fileId, new String[0]);
        if (file != null && this.hasRightToModifyFile(fileId, file.getDocumentClass().getId())) {
            this.fileService.changeFileIndexes(fileId, indexes);
        }
    }

    private boolean hasRightToDeleteFile(Long fileId, Long documentClassId) {
        return this.hasRightToFile(fileId, documentClassId, "delete");
    }

    private boolean hasRightToModifyFile(Long fileId, Long documentClassId) {
        return this.hasRightToFile(fileId, documentClassId, "modify");
    }

    private boolean hasRightToFile(Long fileId, Long documentClassId, String rightLevel) {
        try {
            String userName = SessionUtils.getLoggedUserName();
            int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).custom((Object)rightLevel).build(), (String)userName, (boolean)false, (boolean)false);
            if (rights == -1) {
                log.info("User [" + userName + "] has no " + rightLevel + " rights to document class: " + documentClassId);
                return false;
            }
            DocumentSearch ds = new DocumentSearch(userName, (long)rights);
            ds.addDocClassRestriction(documentClassId.toString());
            ds.addFileIdInRestriction(new Long[]{fileId});
            return ds.count() > 0;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"get/**"})
    public ResponseEntity<DownloadResource> getDocument(@RequestParam(required=false) String fileId, @RequestParam(required=false) String guid, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)fileId) || StringUtils.isNotBlank((CharSequence)guid)) {
            this.readDocumentFromArchive(request, response);
            return null;
        }
        return this.getDocumentFromDisc(request);
    }

    private void readDocumentFromArchive(HttpServletRequest request, HttpServletResponse response) {
        ShowFileServlet servlet = new ShowFileServlet();
        servlet.doGet(request, response);
    }

    private ResponseEntity<DownloadResource> getDocumentFromDisc(HttpServletRequest request) {
        String baseFilesPath = FilenameUtils.normalize((String)(System.getProperty("plusworkflow.home") + "/files"));
        File file = new File(baseFilesPath, this.getNormalizedFileRelativePath(request));
        if (!file.exists()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new DownloadResource(file), (HttpStatusCode)HttpStatus.OK);
    }

    private String getNormalizedFileRelativePath(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        String[] urlParts = requestUrl.split("/api/documents/get/");
        if (urlParts.length == 2) {
            return FilenameUtils.normalize((String)URLDecoder.decode(urlParts[1], "UTF-8"));
        }
        return "";
    }

    @ApiOperation(value="", hidden=true)
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"change"})
    public void change(ChangeFileDto changeFileDto) {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            try {
                MultipartFile multipartFile = changeFileDto.getFile();
                Long fileId = changeFileDto.getFileId();
                Map<Long, Object> indexes = changeFileDto.getIndexes();
                WfFile file = this.fileService.getFile(fileId, new String[0]);
                Long documentClassId = file.getDocumentClass().getId();
                Assert.isTrue((boolean)this.hasRightToModifyFile(fileId, documentClassId), (String)"User must have rights to modify file");
                if (indexes != null) {
                    this.fileService.changeFileIndexes(fileId, indexes);
                }
                if (multipartFile != null) {
                    DocumentDefinition definition = new DocumentDefinition();
                    definition.setDocumentClassId(documentClassId);
                    definition.setFileName(multipartFile.getOriginalFilename());
                    definition.setIndexes(indexes);
                    definition.setUserName(SessionUtils.getLoggedUserName());
                    definition.setSaveAsNewVersion(true);
                    definition.setInputStream(multipartFile.getInputStream());
                    definition.setDescription(file.getDescription());
                    AddDocumentResultMeta result = this.documentService.addDocumentWithMetaResult(definition);
                    Assert.isTrue((boolean)result.getSavedAsNewVersion(), (String)"Parameter getSavedAsNewVersion must be true");
                }
            }
            catch (ServiceException e) {
                throw new ServiceException(e.getCause().getMessage(), (Throwable)e);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @GetMapping(value={"{fileId}/versions"})
    @ResponseBody
    @ApiOperation(value="Get all versions of the document", notes="Returns a list of searched documents")
    @ApiResponses(value={@ApiResponse(code=200, message="Search results matching criteria"), @ApiResponse(code=400, message="Bad input parameter")})
    public List<WfFileDto> getFileVersions(@ApiParam(value="Id of the file for which we want to download all versions (parameter passed in servlet path)", required=true) @PathVariable(value="fileId") Long fileId) {
        String userName = SessionUtils.getLoggedUserName();
        List allVersions = this.fileFinder.getAllVersionsForFile(fileId);
        return allVersions.stream().map(WfFileVersion::getFile).filter(file -> Authorization.hasRightsToReadFile((String)userName, (Long)file.getId())).peek(this::clearVersionFromWFfile).map(WfFileDto::fromEntity).collect(Collectors.toList());
    }

    private void clearVersionFromWFfiles(List<WfFile> files) {
        for (WfFile wfFile : files) {
            this.clearVersionFromWFfile(wfFile);
        }
    }

    private void clearVersionFromWFfile(WfFile wfFile) {
        wfFile.getVersion().setFile(null);
        wfFile.getVersion().setNewestFile(null);
        wfFile.getVersion().setParentFile(null);
    }

    @PutMapping(value={"{fileId}/checkOut"})
    @ResponseBody
    @ApiOperation(value="Changes the data in the database regarding the downloaded document", notes="Changes the data in the database regarding the downloaded document to be changed. Sets the appropriate status, date of downloading the document, and downloading user")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=409, message="Conflict")})
    public ResponseEntity<RestResult> checkOut(@ApiParam(value="Id of the file (parameter passed in servlet path)", required=true) @PathVariable(value="fileId") Long fileId, HttpServletRequest request) {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("fileId", (Object)fileId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CHECKOUT_FILE_FROM_ARCHIVE).params(auditParamsBuilder.build());
        if (this.isFileEditedByOtherUser(fileId, userId)) {
            auditBuilder.buildFailure(request);
            return new ResponseEntity((Object)this.getRestResultForFileEditingByOtherUser(fileId), (HttpStatusCode)HttpStatus.CONFLICT);
        }
        try {
            ResponseEntity<RestResult> result = this.authorizationHelper.ensureFileAccess(fileId, () -> this.checkOut(fileId, userId));
            auditBuilder.buildSuccess(request);
            return result;
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    private RestResult checkOut(Long fileId, String userId) {
        this.fileService.checkOut(fileId, userId);
        return new RestResult(true);
    }

    @PutMapping(value={"{fileId}/undoCheckOut"})
    @ResponseBody
    @ApiOperation(value="Cancels making changes to a downloaded document", notes="Cancels making changes to the document. Sets the appropriate status, resets the document download date and the downloading user.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=409, message="Conflict")})
    public ResponseEntity<RestResult> undoCheckOut(HttpServletRequest request, @ApiParam(value="Id of the file (parameter passed in servlet path)", required=true) @PathVariable(value="fileId") Long fileId) {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("fileId", (Object)fileId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UNDO_CHECKOUT_FILE_FROM_ARCHIVE).params(auditParamsBuilder.build());
        if (this.isFileEditedByOtherUser(fileId, userId) && !Authorization.hasGlobalArchiveRights((String)userId)) {
            auditBuilder.buildFailure(request);
            return new ResponseEntity((Object)this.getRestResultForFileEditingByOtherUser(fileId), (HttpStatusCode)HttpStatus.CONFLICT);
        }
        try {
            ResponseEntity<RestResult> result = this.authorizationHelper.ensureFileAccess(fileId, () -> {
                this.fileService.cancelCheckOut(fileId);
                return new RestResult(true);
            });
            auditBuilder.buildSuccess(request);
            return result;
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @PostMapping(value={"/checkIn"}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Saves a new version of the file we previously downloaded to change", notes="Saves a new version of the file we previously downloaded to change")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public ResponseEntity<RestResult> checkIn(HttpServletRequest request, CheckInFileDto file) throws Exception {
        String userId = FormUtils.getUserIdFromSession((HttpServletRequest)request);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("fileId", (Object)file.getParentFileId()).param("comment", (Object)file.getComment());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CHECK_IN_DOCUMENT_FROM_ARCHIVE).params(auditParamsBuilder.build());
        if (StringUtils.isBlank((CharSequence)file.getComment())) {
            auditBuilder.buildFailure(request);
            throw new ServiceException(this.messageHelper.getMessage("Komentarz_nie_moze_byc_pusty"));
        }
        if (this.getFileStatus(file.getParentFileId()).equals(WfFileVersion.State.STATE_EDIT.toString())) {
            if (!userId.equals(this.getUserEditingFile(file.getParentFileId()))) {
                auditBuilder.buildFailure(request);
                return new ResponseEntity((Object)this.getRestResultForFileEditingByOtherUser(file.getParentFileId()), (HttpStatusCode)HttpStatus.CONFLICT);
            }
            try {
                ResponseEntity<RestResult> result = this.authorizationHelper.ensureFileModifyAccess(file.getParentFileId(), () -> this.modifyFile(file, userId));
                auditBuilder.buildSuccess(request);
                return result;
            }
            catch (FileSizeLimitExceededException e) {
                WfFile parentFile = this.fileService.getFile(file.getParentFileId(), new String[]{"documentClass"});
                DocumentClass dc = parentFile.getDocumentClass();
                RestResult result = new RestResult(false, this.messageHelper.getMessage("Plik_jest_za_duzy_maksymalny_rozmiar_to", new Object[]{file.getFile().getOriginalFilename(), dc.getMaxFileSize() / 1024L}));
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
            }
            catch (Exception exception) {
                RestResult result = new RestResult(false, exception.toString());
                return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        RestResult result = new RestResult(false, this.messageHelper.getMessage("Plik_nie_jest_w_stanie_edycji", new Object[]{file.getFile().getOriginalFilename()}));
        auditBuilder.buildFailure(request);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    private RestResult modifyFile(CheckInFileDto file, String userId) throws Exception {
        DocumentDefinition definition = new DocumentDefinition();
        definition.setFileName(file.getFile().getOriginalFilename());
        definition.setDescription(this.ensureDescriptionNotBlank(file.getParentFileId(), file.getDescription()));
        definition.setUserName(userId);
        definition.setInputStream(file.getFile().getInputStream());
        Long fileId = this.fileService.checkIn(definition, file.getParentFileId(), file.getComment());
        EntityRestResult result = new EntityRestResult(true);
        result.setEntity((Object)fileId);
        return result;
    }

    private String ensureDescriptionNotBlank(Long fileId, String desc) {
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            return desc;
        }
        WfFile file = this.fileService.getFile(fileId, new String[0]);
        return file != null ? file.getDescription() : desc;
    }

    @GetMapping(value={"{fileId}/status"})
    @ResponseBody
    @ApiOperation(value="Download the current status of a document", notes="Current document status")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public String getFileStatus(@ApiParam(value="Id of the file (parameter passed in servlet path)", required=true) @PathVariable(value="fileId") Long fileId, HttpServletRequest request) {
        WfFile file = (WfFile)this.fileFinder.get((Serializable)fileId);
        if (file == null) {
            throw new ServiceException(this.messageHelper.getMessage("Plik_o_podanym_id_nie_istnieje"));
        }
        return this.getFileStatus(fileId);
    }

    private String getFileStatus(Long fileId) {
        return this.fileService.getVersionForFile(fileId).getState();
    }

    private String getUserEditingFile(Long fileId) {
        return this.fileService.getVersionForFile(fileId).getCheckOutUserName();
    }

    private boolean isFileEditedByOtherUser(Long fileId, String userId) {
        if (this.getFileStatus(fileId).equals(WfFileVersion.State.STATE_EDIT.toString())) {
            return !userId.equals(this.getUserEditingFile(fileId));
        }
        return false;
    }

    private RestResult getRestResultForFileEditingByOtherUser(Long fileId) {
        String fileName = this.fileService.getVersionForFile(fileId).getFile().getFileName();
        String message = this.messageHelper.getMessage("Plik_jest_w_trakcie_edycji_inny_uzytkownik", new Object[]{fileName});
        return new RestResult(false, message);
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"{fileId}/canRead"})
    public Map<String, Boolean> hasRightToRead(@PathVariable Long fileId) {
        String userName = SessionUtils.getLoggedUserName();
        Authorization.hasRightsToReadFile((String)userName, (Long)fileId);
        return ImmutableMap.of((Object)"canRead", (Object)Authorization.hasRightsToReadFile((String)userName, (Long)fileId));
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"{fileId}/canDetach"})
    public boolean canDetach(@PathVariable Long fileId, @RequestParam String processId, @RequestParam String activityId) {
        return this.hasRightsToDetach(fileId, processId, activityId);
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"{fileId}/attached-processes"})
    public List<ProcessHistoryLink> getProcessHistoryLinksForDocument(@PathVariable Long fileId) {
        String username = UserContext.current().getUser().getUserName();
        if (!Authorization.hasRightsToReadFile((String)username, (Long)fileId)) {
            throw new NotFullRightsException();
        }
        return this.activityDocumentService.getActivityDocuments(fileId, new String[]{"process"}).stream().map(ActivityDocument::getProcess).filter(this.distinctByKey(ProcessEntity::getProcessId)).filter(process -> this.checkProcessAccess.canUserViewProcessHistory(username, process.getProcessId())).sorted(Comparator.comparing(ProcessEntity::getCreatedTime)).map(this::createProcessHistoryLink).collect(Collectors.toList());
    }

    private List<WfFile> getWfFiles(String processId, String activityId) {
        if (StringUtils.isBlank((CharSequence)processId) && StringUtils.isBlank((CharSequence)activityId)) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_podano_wymaganych_parametrow"));
        }
        String userName = SessionUtils.getLoggedUserName();
        List<Object> files = StringUtils.isNotBlank((CharSequence)activityId) ? this.fileFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"}) : this.fileFinder.getDocumentsFromProcess(processId, new String[]{activityId, "documentClass"});
        files = files.stream().filter(file -> Authorization.hasRightsToReadFile((String)userName, (Long)file.getId())).collect(Collectors.toList());
        this.clearVersionFromWFfiles(files);
        return files;
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private ProcessHistoryLink createProcessHistoryLink(ProcessEntity process) {
        List translations = this.processTranslationService.getByProcessId(process.getProcessId());
        String processName = translations.stream().filter(table -> table.getLanguage().equals(LocaleContextHolder.getLocale().getLanguage())).findFirst().map(ProcessTranslationTable::getName).orElse(process.getName());
        return new ProcessHistoryLink(process.getProcessId(), processName, this.processKey.get(process.getProcessId()));
    }

    private Boolean hasRightsToDetach(Long fileId, String processId, String activityId) {
        return (Boolean)this.transactionWrapper.doInHibernateTransaction(session -> {
            DocumentClass docClass;
            boolean hasRights;
            String userName = SessionUtils.getLoggedUserName();
            ActivityDocument activityDocument = this.activityDocumentService.getActivityDocument(fileId.longValue(), activityId);
            if (activityDocument == null) {
                activityDocument = this.activityDocumentService.getOnlyProcessDocument(fileId.longValue(), processId);
            }
            if (!(hasRights = Authorization.hasRightsToDetachDocument((ActivityDocument)activityDocument, (String)userName, (Long)(docClass = activityDocument.getFile().getDocumentClass()).getId()))) {
                log.info("User [" + userName + "] has no detach rights to document class: " + docClass.getName());
                return false;
            }
            return true;
        });
    }

    @ExceptionHandler(value={IllegalArgumentException.class, RuntimeException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Exception e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleForbidden(Exception e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"), (Throwable)e);
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"fileService", "fileFinder", "documentFinder", "documentService", "documentClassActionService", "authorizationHelper", "activityDocumentService", "transactionWrapper", "messageHelper", "checkProcessAccess", "processTranslationService", "processKey", "cacheFactory"})
    @Autowired
    public DocumentController(FileService fileService, FileFinder fileFinder, DocumentFinder documentFinder, DocumentService documentService, DocumentClassActionService documentClassActionService, AuthorizationHelper authorizationHelper, ActivityDocumentService activityDocumentService, TransactionWrapper transactionWrapper, MessageHelperBean messageHelper, CheckProcessAccess checkProcessAccess, ProcessTranslationService processTranslationService, ShaKey processKey, CacheFactory cacheFactory) {
        this.fileService = fileService;
        this.fileFinder = fileFinder;
        this.documentFinder = documentFinder;
        this.documentService = documentService;
        this.documentClassActionService = documentClassActionService;
        this.authorizationHelper = authorizationHelper;
        this.activityDocumentService = activityDocumentService;
        this.transactionWrapper = transactionWrapper;
        this.messageHelper = messageHelper;
        this.checkProcessAccess = checkProcessAccess;
        this.processTranslationService = processTranslationService;
        this.processKey = processKey;
        this.cacheFactory = cacheFactory;
    }

    public record ProcessHistoryLink(String processId, String translatedProcessName, String processKey) {
    }
}

