/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.results.converter;

import com.plusmpm.util.AdvanceSearchResult;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.results.HeaderToColumnMapper;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.results.dto.ActivityViewFinderResultValue;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.results.dto.ActivityViewFinderResults;
import com.suncode.pwfl.web.controller.api.workflow.activity.finder.view.results.dto.ActivityViewFinderResultsRow;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityViewFinderResultConverter {
    @Autowired
    private HeaderToColumnMapper headerToColumnMapper;

    public ActivityViewFinderResults convert(CountedResult<AdvanceSearchResult> searchResults) {
        List<ActivityViewFinderResultsRow> resultsRows = searchResults.getData().stream().map(this::toAdvanceProcessSearchResultsRow).collect(Collectors.toList());
        return new ActivityViewFinderResults(resultsRows, searchResults.getTotal());
    }

    public Stream<ActivityViewFinderResultsRow> convert(Stream<AdvanceSearchResult> searchResults) {
        return searchResults.map(this::toAdvanceProcessSearchResultsRow);
    }

    private ActivityViewFinderResultsRow toAdvanceProcessSearchResultsRow(AdvanceSearchResult advanceSearchResult) {
        List values = advanceSearchResult.getAlVariables().stream().map(this::toAdvanceProcessSearchResultValue).collect(Collectors.toList());
        return ActivityViewFinderResultsRow.builder().activityDefinitionId(advanceSearchResult.getActivityDefinitionId()).activityId(advanceSearchResult.getActivityId()).processDefinitionId(advanceSearchResult.getProcessDefinitionId()).processId(advanceSearchResult.getProcessId()).values(values).build();
    }

    private ActivityViewFinderResultValue toAdvanceProcessSearchResultValue(AdvanceSearchResult.AdvanceVariable advanceVariable) {
        return new ActivityViewFinderResultValue(this.headerToColumnMapper.fromHeaderToColumn(advanceVariable.getName()), advanceVariable.getDisplayValue());
    }
}

