/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import java.beans.ConstructorProperties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ScheduledTaskAuditParameter {
    private String componentParameterId;
    private Integer position;
    private String value;

    public static ScheduledTaskAuditParameter from(ParameterInfo parameterInfo) {
        return ScheduledTaskAuditParameter.builder().componentParameterId(parameterInfo.getComponentParameterId()).position(parameterInfo.getPosition()).value(parameterInfo.getValue().toString()).build();
    }

    public static ScheduledTaskAuditParameter from(ScheduledTasksParametersTable parameterEntity, ScheduledTaskHelper scheduledTaskHelper) {
        return scheduledTaskHelper.findComponentParameterId(parameterEntity).map(componentParameterId -> ScheduledTaskAuditParameter.builder().componentParameterId((String)componentParameterId).position(parameterEntity.getParameter_position()).value(ScheduledTaskAuditParameter.convertValueToString(parameterEntity, true, scheduledTaskHelper)).build()).orElseGet(() -> ScheduledTaskAuditParameter.builder().position(parameterEntity.getParameter_position()).value(ScheduledTaskAuditParameter.convertValueToString(parameterEntity, false, scheduledTaskHelper)).build());
    }

    private static String convertValueToString(ScheduledTasksParametersTable parameterEntity, boolean isComponent, ScheduledTaskHelper scheduledTaskHelper) {
        boolean isArray = scheduledTaskHelper.isArray(parameterEntity);
        if (isArray) {
            return scheduledTaskHelper.getParameterValues(parameterEntity, isComponent).stream().collect(Collectors.joining(", ", "[", "]"));
        }
        return scheduledTaskHelper.getParameterValue(parameterEntity, isComponent);
    }

    public String toString() {
        String id = StringUtils.isNotBlank((CharSequence)this.componentParameterId) ? this.componentParameterId : String.valueOf(this.position);
        return String.format("%s -> %s", id, this.value);
    }

    @ConstructorProperties(value={"componentParameterId", "position", "value"})
    ScheduledTaskAuditParameter(String componentParameterId, Integer position, String value) {
        this.componentParameterId = componentParameterId;
        this.position = position;
        this.value = value;
    }

    public static ScheduledTaskAuditParameterBuilder builder() {
        return new ScheduledTaskAuditParameterBuilder();
    }

    public String getComponentParameterId() {
        return this.componentParameterId;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getValue() {
        return this.value;
    }

    public static class ScheduledTaskAuditParameterBuilder {
        private String componentParameterId;
        private Integer position;
        private String value;

        ScheduledTaskAuditParameterBuilder() {
        }

        public ScheduledTaskAuditParameterBuilder componentParameterId(String componentParameterId) {
            this.componentParameterId = componentParameterId;
            return this;
        }

        public ScheduledTaskAuditParameterBuilder position(Integer position) {
            this.position = position;
            return this;
        }

        public ScheduledTaskAuditParameterBuilder value(String value) {
            this.value = value;
            return this;
        }

        public ScheduledTaskAuditParameter build() {
            return new ScheduledTaskAuditParameter(this.componentParameterId, this.position, this.value);
        }

        public String toString() {
            return "ScheduledTaskAuditParameter.ScheduledTaskAuditParameterBuilder(componentParameterId=" + this.componentParameterId + ", position=" + this.position + ", value=" + this.value + ")";
        }
    }
}

